/*******************************************************************************
 * Copyright (c) 2007-2008 INdT, (c) 2009 Nokia.
 *
 * This code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 *
 */

/*
 ============================================================================
 Name        : main.c
 Author      : Joost Kop
 Description : Hildon GUI Application in C
 ============================================================================
 */
/* Includes */
#include <hildon/hildon-program.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <libosso.h>
#include <string.h>
#include <stdlib.h>

#include "localisation.h"

#include "SelectTriggerContainer.h"
#include "dbus/ActionManagerDBusClient.h"

/* Defines to add the application to dbus and keep it running
 * Please do not modify "APP_NAME" (or other defines) to different name
 */
#define APP_NAME "actionmanager"
#define APP_VER "0.2"
#define APP_SERVICE "com.nokia.actionmanager"
#define APP_METHOD "/com/nokia/actionmanager"
/* end defines */


static gint
dbus_callback (const gchar *interface, const gchar *method,
               GArray *arguments, gpointer data,
               osso_rpc_t *retval)
{
  printf ("dbus: %s, %s\n", interface, method);

  if (!strcmp (method, "top_application"))
      gtk_window_present (GTK_WINDOW (data));

  return DBUS_TYPE_INVALID;
}

void on_window_close(void)
{
	/* Save the settings */
	ActionManager_save_current_settings();
	/* Quit GTK */
	gtk_main_quit();
}

int main( int argc, char* argv[] )
{
    /* Create needed variables */
    HildonProgram *program;
    HildonWindow *window;
    osso_context_t *osso_cont;
	osso_return_t ret;

	ActionManagerDBusClient_Init();

	locale_init();

    osso_cont = osso_initialize(APP_NAME, APP_VER, TRUE, NULL);
	if (osso_cont == NULL)
    {
    	fprintf (stderr, "osso_initialize failed.\n");
    	exit (1);
    }

    /* Initialize the GTK. */
    gtk_init( &argc, &argv );

    /* Create the hildon program and setup the title */
    program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("Action Manager");

    /* Create HildonWindow and set it to HildonProgram */
    window = show_select_trigger_container_window();
    hildon_program_add_window(program, window);

    /* Quit program when window is closed. */
     g_signal_connect (G_OBJECT (window), "delete_event",
 		      G_CALLBACK (on_window_close), NULL);

     /* Quit program when window is otherwise destroyed. */
     g_signal_connect (G_OBJECT (window), "destroy",
 		      G_CALLBACK (gtk_main_quit), NULL);

    ret = osso_rpc_set_cb_f (osso_cont,
                           APP_SERVICE,
                           APP_METHOD,
                           APP_SERVICE,
                           dbus_callback, GTK_WIDGET( window ));
	if (ret != OSSO_OK) {
		fprintf (stderr, "osso_rpc_set_cb_f failed: %d.\n", ret);
	    exit (1);
	}

    /* Begin the main application */
    gtk_main();

    /* Exit */
    return 0;
}
