/*******************************************************************************
 * Copyright (c) 2007-2008 INdT, (c) 2009 Nokia.
 *
 * This code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 *
 */

/*
 ============================================================================
 Name        : SelectTriggerContainer.c
 Author      : Joost Kop
 Description : This view lets the user select the TriggerContainer
 ============================================================================
 */
/* Includes */
#include <hildon/hildon.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <string.h>
#include <stdlib.h>

#include "localisation.h"

#include "SelectTriggerContainer.h"
#include "SelectTrigger.h"
#include "dbus/ActionManagerDBusClient.h"


GtkWidget *create_triggercontainer_area(char **list)
{
    GtkWidget *pannable_area;
    GtkWidget *table;
    GtkWidget *button;
    char *container_name;
    int i, size;

    size = g_strv_length(list);
    /* Create button and add it to main view */
	table = gtk_table_new (size, 1, FALSE);

	/* set the spacing to 10 on x and 10 on y */
	gtk_table_set_row_spacings (GTK_TABLE (table), 5);

	/* this simply creates a grid of buttons on the table */
	for (i = 0; i < size; i++)
	{
		container_name = g_strdup(list[i]);
		button = gtk_button_new_with_label (container_name);
		/*  *container_name deleted by destroy of the signal! */
		g_signal_connect (G_OBJECT (button), "clicked",
						  G_CALLBACK (show_select_trigger_window), container_name);
		gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, i+1, i+2);
	}

	gtk_widget_show (table);

    /* pack the table into the scrolled window */
	pannable_area = hildon_pannable_area_new ();
	hildon_pannable_area_add_with_viewport (
	  HILDON_PANNABLE_AREA (pannable_area), table);

	return pannable_area;
}

HildonWindow *show_select_trigger_container_window(void)
{
    HildonWindow *window;
    GtkWidget *label;
    GtkWidget *triggercontainer_area;
    GtkWidget *vbox;
    gboolean succes;
    char **list;

    /* Create HildonWindow */
    window = HILDON_WINDOW(hildon_stackable_window_new ());

    /* get data */
    succes = ActionManager_get_all_trigger_containers(&list);
    if(succes)
    {
		/* Create a box and pack the widgets into it */
		vbox = gtk_vbox_new (FALSE, 5);

		/* Create label */
		label =  gtk_label_new (_("Change action for:"));
		gtk_box_pack_start (GTK_BOX (vbox),
							label,
							FALSE,
							FALSE,
							0);
		/* Create triggercontainer area */
		triggercontainer_area = create_triggercontainer_area(list);;
		g_strfreev (list);
		gtk_box_pack_start (GTK_BOX (vbox),
							triggercontainer_area,
							TRUE,
							TRUE,
							0);

		/* Add the box into the window*/
		gtk_container_add (GTK_CONTAINER (window), vbox);
    }
    else
    {
    	/* Create label */
    	label =  gtk_label_new (_("Error connection to ActionManagerDaemon!"));
    	gtk_container_add (GTK_CONTAINER (window), label);
    }

    gtk_widget_show_all ( GTK_WIDGET ( window ) );

    return window;
}
