/*******************************************************************************
 * Copyright (c) 2007-2008 INdT, (c) 2009 Nokia.
 *
 * This code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the package
 *
 */

/*
 ============================================================================
 Name        : SelectAction.c
 Author      : Joost Kop
 Description : This view lets the user select the Action for the trigger
 ============================================================================
 */
/* Includes */
#include <hildon/hildon.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>

#include "localisation.h"

#include "SelectAction.h"
#include "dbus/ActionManagerDBusClient.h"

void select_action(gpointer instance, gpointer data);
GtkWidget *create_trigger_settings_area(char *trigger_container, char *trigger);
GtkWidget *create_action_list_area(char *trigger_container, char *trigger);


HildonWindow *show_select_action_window(gpointer instance, gpointer data)
{
	HildonWindow *window;
    GtkWidget *settings_area;
    GtkWidget *seperator1;
    GtkWidget *action_area;
    GtkWidget *vbox;

    char **list = g_strsplit((char*)data, SELECT_ACTION_WINDOW_DELIMITER, 0);
    char *trigger = list[SELECT_ACTION_WINDOW_PARAM_TRIGGER];
    char *trigger_container = list[SELECT_ACTION_WINDOW_PARAM_CONTAINER];

    /* Create the main window */
    window = HILDON_WINDOW(hildon_stackable_window_new());
    gtk_window_set_title ( GTK_WINDOW (window), _(trigger));

    vbox = gtk_vbox_new (FALSE, 5);

    /* Create TriggerContainer setting area */
    settings_area = create_trigger_settings_area(trigger_container, trigger);
    if(settings_area != NULL)
    {
		gtk_box_pack_start (GTK_BOX (vbox),
							settings_area,
							FALSE,
							FALSE,
							0);
		/*Create seperator */
		seperator1 = gtk_hseparator_new ();
		gtk_box_pack_start (GTK_BOX (vbox),
							seperator1,
							FALSE,
							FALSE,
							0);
    }
	action_area = create_action_list_area(trigger_container, trigger);
    gtk_box_pack_start (GTK_BOX (vbox),
						action_area,
                        TRUE,
                        TRUE,
                        0);

    gtk_container_add (GTK_CONTAINER (window),
                       vbox);

    /* This call show the window and also add the window to the stack */
    gtk_widget_show_all (GTK_WIDGET(window));

    g_strfreev(list);

    return window;
}

void select_action(gpointer instance, gpointer data)
{
    char **list = g_strsplit((char*)data, SELECT_ACTION_WINDOW_DELIMITER, 0);
    char *trigger_container = list[SELECT_ACTION_WINDOW_PARAM_CONTAINER];
    char *trigger = list[SELECT_ACTION_WINDOW_PARAM_TRIGGER];
    char *action = list[SELECT_ACTION_WINDOW_PARAM_ACTION];

    gboolean active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(instance));
    /* Enable/Disable the action */
    ActionManager_set_action(trigger_container, trigger, action, active);
    g_strfreev(list);
}

GtkWidget *create_trigger_settings_area(char *trigger_container, char *trigger)
{
	GtkWidget *label;
	gchar *label_text;
    GtkWidget *button;
	GtkWidget *vbox = NULL;

    /* todo: implement if this Trigger supports changing settings...*/
	if(0)
	{
		button = gtk_button_new_with_label (_("Change settings"));
		gtk_widget_set_sensitive(button, FALSE);

		/* Pack label and button */
		vbox = gtk_vbox_new (FALSE, 5);
		label_text = g_strconcat(_(trigger), " ",_("settings:"), NULL);
		label = gtk_label_new (label_text);
		g_free(label_text);
		gtk_box_pack_start (GTK_BOX (vbox),
							label,
							FALSE,
							FALSE,
							0);
		gtk_box_pack_start (GTK_BOX (vbox),
							button,
							TRUE,
							TRUE,
							0);
	}
	return vbox;
}

GtkWidget *create_action_list_area(char *trigger_container, char *trigger)
{
	GtkWidget *vbox;
	GtkWidget *label;
    GtkWidget *pannable_area;
    GtkWidget *table;
    GtkWidget *select_button;
    GtkWidget *settings_button;
    gboolean succes;
    char **action_list;
    char **used_actions;
    char *select_button_data;
    int i, j, size, used_size;

	/* Get data */
	succes = ActionManager_get_all_actions(&action_list);
	succes = ActionManager_get_used_actions_from_trigger(trigger_container, trigger, &used_actions);
	if(succes)
	{
		size = g_strv_length(action_list);
		used_size = g_strv_length(used_actions);

	    /* Create button and add it to main view */
		table = gtk_table_new (size, 2, FALSE);
		/* set the spacing to 10 on x and 10 on y */
		gtk_table_set_row_spacings (GTK_TABLE (table), 5);
		gtk_widget_show (table);

		/* this simply creates a grid of toggle buttons on the table
		* to demonstrate the scrolled window. */
		for (i = 0; i < size; i++)
		{
			select_button = gtk_check_button_new_with_label(action_list[i]);
			/* If Action is used, "Select" the button */
			for( j=0; j<used_size ;j++)
			{
				if(g_strcmp0(action_list[i], used_actions[j]) == 0)
				{
					gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(select_button), TRUE);
				}
			}
			select_button_data = g_strjoin(SELECT_ACTION_WINDOW_DELIMITER, trigger_container, trigger, action_list[i], NULL);
			/*  *data deleted by destroy of the signal! */
			g_signal_connect (G_OBJECT (select_button), "toggled",
							  G_CALLBACK (select_action), select_button_data);
			settings_button = gtk_button_new_with_label(_("Action settings..."));
			gtk_widget_set_sensitive(settings_button, FALSE);
			/* g_signal_connect (G_OBJECT (settings_button), "clicked",
							  G_CALLBACK (show_settings_action_window), action_list[i]);*/
			gtk_table_attach_defaults (GTK_TABLE (table), select_button, 1, 2, i+1, i+2);
			gtk_table_attach_defaults (GTK_TABLE (table), settings_button, 2, 3, i+1, i+2);
		}
		g_strfreev(action_list);
		g_strfreev(used_actions);

		/* pack the table into the scrolled window */
		pannable_area = hildon_pannable_area_new ();
		hildon_pannable_area_add_with_viewport (
		  HILDON_PANNABLE_AREA (pannable_area), table);
		/* Pack label and panable area */
		vbox = gtk_vbox_new (FALSE, 5);
		label = gtk_label_new (_("Select the action to be executed:"));
	    gtk_box_pack_start (GTK_BOX (vbox),
							label,
	                        FALSE,
	                        FALSE,
	                        0);
	    gtk_box_pack_start (GTK_BOX (vbox),
							pannable_area,
	                        TRUE,
	                        TRUE,
	                        0);
	}
	else
	{
		vbox = gtk_label_new (_("Error connection to ActionManagerDaemon!"));
	}
	return vbox;
}
