#include "trackerdialog.h"
#include "ui_trackerdialog.h"
#include <QMessageBox>
#include <QTextStream>

TrackerDialog::TrackerDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::TrackerDialog)
{
    ui->setupUi(this);
//    ui->txtAllowance->setValidator(new QIntValidator(0, 99999, this));

    QString sKey = "config/allow";
    QString sAllow = mSelFood.value(sKey).toString();
    if (sAllow != 0)
    {
  //      ui->txtAllowance->setText(sAllow);
        bool ok;
        dAllowance = sAllow.toDouble(&ok);
        if (!ok)
        {
            dAllowance = 0;
    //        ui->txtAllowance->setText("0");
        }
    }
    else
    {
      //  ui->txtAllowance->setText("0");
        dAllowance = 0;
    }
}

TrackerDialog::~TrackerDialog()
{
    delete ui;
}

void TrackerDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void TrackerDialog::setButtons(bool enabled)
{
    //ui->btnEdit->setEnabled(enabled);
    ui->btnSave->setEnabled(enabled);
    //ui->btnUpdate->setEnabled(!enabled);
    //ui->txtAllowance->setEnabled(!enabled);
    //ui->txtBonus->setEnabled(enabled);
    ui->txtBreakfast->setEnabled(enabled);
    ui->txtDate->setEnabled(enabled);
    ui->txtDinner->setEnabled(enabled);
    ui->txtLunch->setEnabled(enabled);
    ui->txtSnacks->setEnabled(enabled);
    ui->txtRemainder->setEnabled(false);
    ui->txtTotal->setEnabled(false);
}

void TrackerDialog::on_btnEdit_clicked()
{
    setButtons(false);
    //ui->txtAllowance->setFocus();
}


void TrackerDialog::calcTotals()
{
    if (dAllowance==0)
    {
        QMessageBox::information(this, tr("Calculate Totals"),
        tr("You must set the allowance first."));
        return;
    }
    double tots;

    tots = ui->txtBreakfast->value();
    tots += ui->txtLunch->value();
    tots += ui->txtDinner->value();
    tots += ui->txtSnacks->value();
    tots -= ui->txtBonus->value();
    QString sTot;
    QTextStream(&sTot) << tots;

    ui->txtTotal->setText(sTot);

    double dRem = dAllowance - tots;
    sTot="";
    QTextStream(&sTot) << dRem;

    ui->txtRemainder->setText(sTot);

}

void TrackerDialog::setDate(QDate dDate)
{
    ui->txtDate->setDate(dDate);
    // Load the values for this day
    QString sDate = dDate.toString("ddMMyyyy");

    QString sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_breakfast";
    QString sBFast = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_lunch";
    QString sLunch = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_dinner";
    QString sDinner = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_snacks";
    QString sSnacks = mSelFood.value(sKey).toString();

    sKey = "";
    QTextStream(&sKey) << "data/" << sDate << "_bonus";
    QString sBonus = mSelFood.value(sKey).toString();

    bool ok;
    double answer;
    answer = sBFast.toDouble(&ok);
    if (ok)
    {
        ui->txtBreakfast->setValue(answer);
    }
    else
    {
        ui->txtBreakfast->setValue(0);
    }

    answer = sLunch.toDouble(&ok);
    if (ok)
    {
        ui->txtLunch->setValue(answer);
    }
    else
    {
        ui->txtLunch->setValue(0);
    }

    answer = sDinner.toDouble(&ok);
    if (ok)
    {
        ui->txtDinner->setValue(answer);
    }
    else
    {
        ui->txtDinner->setValue(0);
    }

    answer = sSnacks.toDouble(&ok);
    if (ok)
    {
        ui->txtSnacks->setValue(answer);
    }
    else
    {
        ui->txtSnacks->setValue(0);
    }

    answer = sBonus.toDouble(&ok);
    if (ok)
    {
        ui->txtBonus->setValue(answer);
    }
    else
    {
        ui->txtBonus->setValue(0);
    }
}

void TrackerDialog::saveDate(QDate dDate)
{
    // Load the values for this day
    QString sDate = dDate.toString("ddMMyyyy");

    QString sKey = "";
    QString sValue = "";
    QTextStream(&sKey) << "data/" << sDate << "_breakfast";
    QTextStream(&sValue) << ui->txtBreakfast->value();
    mSelFood.setValue(sKey, sValue);

    sKey = "";
    sValue = "";
    QTextStream(&sKey) << "data/" << sDate << "_lunch";
    QTextStream(&sValue) << ui->txtLunch->value();
    mSelFood.setValue(sKey, sValue);

    sKey = "";
    sValue = "";
    QTextStream(&sKey) << "data/" << sDate << "_dinner";
    QTextStream(&sValue) << ui->txtDinner->value();
    mSelFood.setValue(sKey, sValue);

    sKey = "";
    sValue = "";
    QTextStream(&sKey) << "data/" << sDate << "_snacks";
    QTextStream(&sValue) << ui->txtSnacks->value();
    mSelFood.setValue(sKey, sValue);

    sKey = "";
    sValue = "";
    QTextStream(&sKey) << "data/" << sDate << "_bonus";
    QTextStream(&sValue) << ui->txtBonus->value();
    mSelFood.setValue(sKey, sValue);
}


void TrackerDialog::on_txtBreakfast_valueChanged(double )
{
    calcTotals();
}

void TrackerDialog::on_txtLunch_valueChanged(double )
{
    calcTotals();
}

void TrackerDialog::on_txtDinner_valueChanged(double )
{
    calcTotals();
}

void TrackerDialog::on_txtSnacks_valueChanged(double )
{
    calcTotals();
}

void TrackerDialog::on_txtBonus_valueChanged(double )
{
    calcTotals();
}

void TrackerDialog::on_txtDate_dateChanged(QDate date)
{
    setDate(date);
}


void TrackerDialog::on_btnSave_clicked()
{
    QDate dDate;
    dDate = ui->txtDate->date();
    saveDate(dDate);
    this->close();

}

void TrackerDialog::on_btnClose_clicked()
{
    this->close();
}
