/*
 * Some parts of this file may be from zeemoted, which is also under GPL.
 *
 * All original portions are
 * Copyright (C) 2009 <davidfalkayn@gmail.com>.
 *
 * Accelemymote is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Accelemymote is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with accelemymote.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

// This file has function definitions specific to the uinput kernel module. Events are created in uinput which get returned on joydev.
// Most of this file is full of meticulous error-checking to make sure the uinput device is found in any of its possible locations.
// As the location is known in Maemo 5, this isn't really necessary, but there's no reason to remove it.

#include <stdio.h>
#include <string.h> // memset()
#include <linux/uinput.h>
#include <fcntl.h>

#include "uinput.h"

extern int debug;

/* uinput device file */
static const char uinput_paths[4][20] = {"/dev/input/uinput", "/dev/uinput", "/dev/misc/uinput", "\0"};
static const char* uinput_path = uinput_paths[0];
// The first is correct for N900. Kubuntu doesn't have a udev rule, so the second path works for my box.
// The third is also apparently legitimate in some cases.
// This is an old "fixed" bug with udev/debian: http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=270446
// The uinput device file may also need permissions changed (udev really fubared uinput). See the debian rules file
// for one solution.


/* Insert uinput event */
int do_uinput( int fd, unsigned short key, int pressed, unsigned short event_type ) 
{
  struct input_event event;
  memset(&event, 0 , sizeof(event));

  gettimeofday(&event.time, NULL);
  event.type = event_type;
  event.code = key;
  event.value = pressed;
  
  if(write(fd,&event,sizeof(event)) != sizeof(event))
    perror("Writing event");

  if (debug) printf("Event: t=%i type=%i key=%i value=%i\n",event.time.tv_sec,event_type,key,pressed);

  return 1;
}


/* Init uinput */
int init_uinput_device()
{
  struct uinput_user_dev dev;
  int fd = -1;
  int paths = 0;

  fd = access(uinput_path, F_OK); // Exists
  while (uinput_path[0] && fd) //Check all the possible paths for existing uinput device
  { 
    printf("Unable to find uinput device at %s.\n", uinput_path);
    uinput_path = uinput_paths[++paths];
    fd = access (uinput_path, F_OK); // Exists
  }

  if(fd)
  {
    printf("Uinput module doesn't seem to be installed. Perhaps a 'sudo modprobe uinput' will do it?\n");
    return -1;
  }

  fd = access (uinput_path, (R_OK| W_OK)); //Read/write permissible by app
  if(fd )
  {
    printf("Uinput device node (at %s) has the wrong permissions. \n", uinput_path);
    printf("I'd blame udev. Your options are to fix the udev rules and reboot or chgrp/chown/chmod the device node.\n");
    return -1;
  }
  
  fd = open(uinput_path, O_RDWR);
  if(fd < 0)
  {
    printf("Uinput module installed and accessible, but device node %s couldn't be opened.\n", uinput_path);
    return -1;
  }
  
  memset(&dev,0,sizeof(dev));
  strncpy(dev.name, "Accelemymote", UINPUT_MAX_NAME_SIZE);
  dev.id.bustype = BUS_USB;
  dev.id.version = 0x01;
  
  if(write(fd, &dev, sizeof(dev)) < sizeof(dev))
  {
    printf("Registering device at uinput device node %s failed\n", uinput_path);
    return -1;
  }

  if(ioctl(fd, UI_SET_EVBIT, EV_ABS) < 0) perror("setting EV_ABS");
  if(ioctl(fd, UI_SET_ABSBIT, ABS_X) < 0) perror("setting ABS_X");
  if(ioctl(fd, UI_SET_ABSBIT, ABS_Y) < 0) perror("setting ABS_Y");
  
  if(ioctl(fd, UI_DEV_CREATE) < 0)        perror("Create device");
  return fd;
}

