import Qt 4.7

Rectangle {
    id:body
    signal closing

    height: 480
    width: 800
    Gradient {
      id: body_background
      GradientStop { position: 0.0; color: "#EEEEEE" }
      GradientStop { position: 0.2; color: "#FFFFFF" }
      GradientStop { position: 0.6; color: "#FFFFFF" }
      GradientStop { position: 1.0; color: "#CCCCCC" }
    }

    Gradient {
      id: body_background_sending
      GradientStop { position: 0.0; color: "#74F50A" }
      GradientStop { position: 1.0; color: "#438F04" }
    }

    Gradient {
      id: body_background_error
      GradientStop { position: 0.0; color: "#F53D0A" }
      GradientStop { position: 1.0; color: "#8F1404" }
    }

    gradient: listener.sending_property ? ( listener.error_property ? body_background_error : body_background_sending ) : body_background

    MouseArea {
      anchors.fill: parent
      onPressed: listener.start_sending(ip_input.text)
      onReleased: listener.stop_sending()
    }

    Text {
      id:center
        width: parent.width*.9
        anchors.centerIn: parent
        wrapMode: Text.WordWrap
        text: listener.status_property
        font.bold: true
        color: "#333333"
        font.pointSize: 32
    }

    Row {
        id:panel
        height: ip_input.height*2
        spacing: 10
        anchors {
            margins: body.height*.03
            bottom: body.bottom
            horizontalCenter: body.horizontalCenter
        }

        Text {
            id: ip_label 
            font.pointSize: 24
            height: parent.height
            verticalAlignment: Text.AlignVCenter
            font.bold: true
            text: 'Receiver IP'
        }

        Rectangle {
            id: ip_background
            width: ip_input.width*1.2
            height: parent.height
            color: '#FFFFFF'
            radius: height*.1
            smooth: true
            border { width: 1; color: '#555555' }

            TextInput {
                id: ip_input
                font.pointSize: 24
                focus: true
                color: ip_input.acceptableInput ? "black" : "red"
                anchors.centerIn: parent
                horizontalAlignment: TextInput.AlignHCenter
                text: '192.168.000.100'
                inputMask: "009.009.009.009; "
                validator: RegExpValidator { regExp: /^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\.|$)){4}$/ }
            }
        }
    }

    Text {
        id: close_button
        height: 48
        width: height*2
//        text: '✖'
        text: ''
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.pointSize: close_button.height
        anchors {
            top: parent.top
            right: parent.right }

        MouseArea {
            anchors.fill: parent
            onClicked: closing()
        }
    }
}