/*
  abscal
*/

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/input.h>

#define test_bit(bit, array)    (array[bit/8] & (1<<(bit%8)))

void info(int fd) {
  unsigned char evtype_bitmask[EV_MAX/8 + 1];
  char name[256]= "Unknown";
  
  if(ioctl(fd, EVIOCGNAME(sizeof(name)), name) < 0) {
    perror("evdev ioctl");
  }

  printf("Name: %s\n", name);

  if(ioctl(fd, EVIOCGBIT(0, sizeof(evtype_bitmask)), evtype_bitmask) < 0)
    perror("evdev ioctl");
  
  printf("Supported event types:\n");
  
  int yalv;
  for (yalv = 0; yalv < EV_MAX; yalv++) {
    if (test_bit(yalv, evtype_bitmask)) {
        /* the bit is set in the event types list */
        printf("  Event type 0x%02x ", yalv);
        switch ( yalv)
            {
            case EV_SYN :
                printf(" (Synch Events)\n");
                break;
            case EV_KEY :
                printf(" (Keys or Buttons)\n");
                break;
            case EV_REL :
                printf(" (Relative Axes)\n");
                break;
            case EV_ABS :
                printf(" (Absolute Axes)\n");
                break;
            case EV_MSC :
                printf(" (Miscellaneous)\n");
                break;
            case EV_LED :
                printf(" (LEDs)\n");
                break;
            case EV_SND :
                printf(" (Sounds)\n");
                break;
            case EV_REP :
                printf(" (Repeat)\n");
                break;
            case EV_FF :
            case EV_FF_STATUS:
                printf(" (Force Feedback)\n");
                break;
            case EV_PWR:
                printf(" (Power Management)\n");
                break;
            default:
                printf(" (Unknown: 0x%04hx)\n",
             yalv);
            }
    }
  }
}


void get_pos(int fd, int *x, int *y) {
  int released = 0;
  struct input_event ev;
  
  while(!released) {
    read(fd, &ev, sizeof(struct input_event));
    
    //    printf("Event: time %ld.%06ld, type %d, code %d, value %d\n",
    //	   ev.time.tv_sec, ev.time.tv_usec, ev.type,
    //	   ev.code, ev.value);

    switch(ev.type) {
    case EV_ABS:
      if(ev.code == ABS_X) *x = ev.value;
      if(ev.code == ABS_Y) *y = ev.value;
      break;

    case EV_KEY:
      //      printf("key event: %d = %d\n", ev.code, ev.value);
      if(ev.code == BTN_TOUCH && !ev.value) {
	printf("released at: %d %d\n", *x, *y);
	released = 1;
      }
      break;

    default:
      break;
    }
  }
}

void show_bounds(int fd) {
  struct input_absinfo absinfo;

  if(ioctl(fd, EVIOCGABS(ABS_X), &absinfo) < 0) 
    perror("ioctl(EVIOCGABS(ABS_X))");

  printf("x min: %d\n", absinfo.minimum);
  printf("x max: %d\n", absinfo.maximum);

  if(ioctl(fd, EVIOCGABS(ABS_Y), &absinfo) < 0) 
    perror("ioctl(EVIOCGABS(ABS_Y))");

  printf("y min: %d\n", absinfo.minimum);
  printf("y max: %d\n", absinfo.maximum);
}

void set_bounds(int fd, int min_x, int min_y, int max_x, int max_y) {
  struct input_absinfo absinfo;

  if(ioctl(fd, EVIOCGABS(ABS_X), &absinfo) < 0) 
    perror("ioctl(EVIOCGABS(ABS_X))");

  absinfo.minimum = min_x;
  absinfo.maximum = max_x;

  if(ioctl(fd, EVIOCSABS(ABS_X), &absinfo) < 0) 
    perror("ioctl(EVIOCSABS(ABS_X))");

  if(ioctl(fd, EVIOCGABS(ABS_Y), &absinfo) < 0) 
    perror("ioctl(EVIOCGABS(ABS_Y))");

  absinfo.minimum = min_y;
  absinfo.maximum = max_y;

  if(ioctl(fd, EVIOCSABS(ABS_Y), &absinfo) < 0) 
    perror("ioctl(EVIOCSABS(ABS_Y))");
}

int main(int argc, char **argv) {
  if(argc < 2) {
    printf("Usage: abscal DEVICE [min_x max_x min_y max_y]\n");
    return 1;
  }

  int fd = open(argv[1], O_RDWR);
  if(fd < 0) {
    perror("open");
    return 1;
  }

  info(fd);

  show_bounds(fd);

  int min_x, min_y, max_x, max_y;

  if(argc < 6) {
    printf("touch topleft\n");
    get_pos(fd, &min_x, &min_y);

    printf("touch bottomright\n");
    get_pos(fd, &max_x, &max_y);

  } else {
    min_x = atoi(argv[2]);
    max_x = atoi(argv[3]);
    min_y = atoi(argv[4]);
    max_y = atoi(argv[5]);
  }

  set_bounds(fd, min_x, min_y, max_x, max_y);
  close(fd);

  return 0;
}
