/*
 * Copyright (C) 2010 Felipe Zimmerle <felipe.zimmerle@collabora.co.uk>
 *
 * This file is part of 4x4 inclinometer.
 *
 * 4x4 inclinometer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * 4x4 inclinometer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "inclinometer.h"
#include "pictureitem.h"
#include <math.h>

Inclinometer::Inclinometer(QGraphicsScene *scene)
    : QGraphicsView(scene)
{
    /* Window */
    setRenderHint(QPainter::Antialiasing);
    setBackgroundBrush(QPixmap(":/res/background.png"));
    setCacheMode(QGraphicsView::CacheBackground);
    setWindowTitle("4x4 Inclinometer");
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    resize(800, 480);

    /* front view */
    const QPixmap p(":res/troller_front_small.png");
    front = new PictureItem(p, scene);
    front->setPixmap(p);
    front->setPos(90,120);
    frontText = new QGraphicsTextItem(0, scene);
    frontText->setPlainText(QString::number(0));
    frontText->setDefaultTextColor(Qt::white);
    frontText->setFont(QFont("Arial", 20, 100, FALSE));
    frontText->setPos(200,340);


    /* side view */
    const QPixmap s(":res/troller_sideview_small.png");
    side = new PictureItem(s, scene);
    side->setPixmap(s);
    side->setPos(390,145);
    sideText = new QGraphicsTextItem(0, scene);
    sideText->setPlainText(QString::number(0));
    sideText->setPos(540,340);
    sideText->setDefaultTextColor(Qt::white);
    sideText->setFont(QFont("Arial", 20, 100, FALSE));

    /* update */
    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(updateUi()));
    timer->start(200);

 }

bool Inclinometer::updateUi()
{
    currentPos pos;
    getCurrentPos(&pos);

    if (pos.pitch > 75)
    {
        front->animateToAngle(75);
        frontText->setPlainText(QString::number(75));
    }
    else if (pos.pitch < -75)
    {
        front->animateToAngle(-75);
        frontText->setPlainText(QString::number(-75));
    }
    else if (pos.pitch % 2 == 0)
    {
        front->animateToAngle(pos.pitch);
        frontText->setPlainText(QString::number(pos.pitch));
    }

    if (pos.roll > 75)
    {
        side->animateToAngle(75);
        sideText->setPlainText(QString::number(75));
    }
    else if (pos.roll < -75)
    {
        side->animateToAngle(-75);
        sideText->setPlainText(QString::number(-75));
    }
    else if (pos.roll % 2 == 0)
    {
        side->animateToAngle(pos.roll);
        sideText->setPlainText(QString::number(pos.roll));
    }

    return TRUE;
}

Inclinometer::~Inclinometer()
{
}

void Inclinometer::getCurrentPos(currentPos *pos)
{
    QFile f(PROC_ENTRY);
    if (!f.exists() or !f.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        pos->pitch = (rand() % 100)-30;
        pos->roll = (rand() % 100)-30;
    }
    else
    {
        QByteArray line = f.readLine();
        QRegExp rx("([0-9-]+) ([0-9-]+) ([0-9-]+)");
        rx.indexIn(line);
        qreal x = rx.cap(1).toInt();
        qreal y = rx.cap(2).toInt();
        qreal z = rx.cap(3).toInt();

        qreal pitch = atan2((qreal) x, (qreal) -y);
        qreal roll = atan2((qreal) y, (qreal) -z);

        pos->pitch = (pitch * 180/M_PI)*-1;
        pos->roll = (roll * 180/M_PI) + 90;
        f.close();
    }
}
