/*
 * Copyright (C) 2010 Felipe Zimmerle <felipe.zimmerle@collabora.co.uk>
 *
 * This file is part of 4x4 inclinometer.
 *
 * 4x4 inclinometer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * 4x4 inclinometer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef INCLINOMETER_H
#define INCLINOMETER_H

#include <QtCore>
#include <QtGui>
#include "pictureitem.h"

#define PROC_ENTRY "/sys/class/i2c-adapter/i2c-3/3-001d/coord"

typedef struct currentPos
{
    int pitch;
    int roll;
    int z;
} currentPos;

class Inclinometer : public QGraphicsView
{
    Q_OBJECT

public:
    Inclinometer(QGraphicsScene *scene);
    ~Inclinometer();
    void getCurrentPos(currentPos *);

public slots:
    bool updateUi();

private:
    PictureItem *front;
    QGraphicsTextItem *frontText;
    PictureItem *side;
    QGraphicsTextItem *sideText;

};

#endif // INCLINOMETER_H
