/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/*! ---------------------------------------------------------------
 * $Id$
 *
 * \file MainWindow.cpp
 * \brief MainWindow implementation
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */

#include "MainWindow.h"
#include <QAction>
#include <QMenu>
#include <QMenuBar>
#include <QHBoxLayout>
#include <QString>
#include "defs.h"

MainWindow::MainWindow(QWidget *parent) : QMainWindow(NULL)
{
    //setParent(parent);
    setWindowTitle(tr("15shki"));
    this->showMaximized();
    fullscreen = 0;

    QWidget *centralWidget = new QWidget(this);
    QPalette pe = centralWidget->palette();
    pe.setColor(centralWidget->backgroundRole(), QColor(BACKGROUND_COLOR_RED,
                                                 BACKGROUND_COLOR_GREEN,
                                                 BACKGROUND_COLOR_BLUE));
    centralWidget->setPalette(pe);
    centralWidget->setAutoFillBackground( true );
    this->setCentralWidget(centralWidget);

    game = new Game(this);
    QPushButton *newButton = new QPushButton(tr("New game"), this);
    QPushButton *exitButton = new QPushButton(tr("Exit"), this);
    scoreLabel = new QLabel(tr("Movements done:   0"), this);
    timeLabel = new QLabel(tr("Spent time: 00:00"), this);
    QPalette pe2 = scoreLabel->palette(); 
    pe2.setColor(scoreLabel->foregroundRole(), QColor(255, 0, 0));
    scoreLabel->setPalette(pe2);
    timeLabel->setPalette(pe2);
    scoreLabel->setVisible(false);
    timeLabel->setVisible(false);
    newButton->setVisible(false);
    exitButton->setVisible(false);
    newAction = new QAction(tr("New game"), this);
    menuBar()->addAction(newAction);

    /* Connects */
    connect(newButton, SIGNAL(clicked()), this, SLOT(newGame()));
    connect(exitButton, SIGNAL(clicked()), this, SLOT(close()));
    connect(game, SIGNAL(movementsChanged(int)),
                     this, SLOT(onMovementsChanged(int)));
    connect(game, SIGNAL(durationChanged(int)), this, SLOT(onDurationChanged(int)));
    connect(newAction, SIGNAL(triggered()), this, SLOT(newGame()));



    /* Layouts */
    QHBoxLayout *mainLayout = new QHBoxLayout();
    QVBoxLayout *menuLayout = new QVBoxLayout();
    centralWidget->setLayout(mainLayout);
    //mainLayout->addItem(menuLayout);
    mainLayout->addWidget(game);
    menuLayout->addWidget(newButton);
    menuLayout->addWidget(exitButton);
    menuLayout->addStretch();
    menuLayout->addWidget(scoreLabel);
    menuLayout->addWidget(timeLabel);
    menuLayout->addStretch();
    menuLayout->addStretch();
    menuLayout->addStretch();

}

void MainWindow::setScreen(int width, int height)
{
    game->setScreen(width, height);
}

void MainWindow::newGame()
{
    game->newGame();
    fullscreen = 1;
    this->showFullScreen();
    
}

void MainWindow::mousePressEvent(QMouseEvent *event)
{
    if (fullscreen)
    {
        this->showMaximized();
        fullscreen = 0;
    }
    else
    {
        this->showFullScreen();
        fullscreen = 1;
    }
}

void MainWindow::onMovementsChanged(int movements)
{
    scoreLabel->setText(tr("Movements done: ") + QString::number(movements));
}

void MainWindow::onDurationChanged(int duration)
{
    QString min, sec;
    if ((duration / 60) < 10)
        min = "0" + QString::number(duration / 60);
    else
        min = QString::number(duration / 60);

    if ((duration % 60) < 10)
        sec = "0" + QString::number(duration % 60);
    else
        sec = QString::number(duration % 60);
    timeLabel->setText(tr("Spent time: ") + min + ":" + sec);
}

/* ===[ End of file $HeadURL$ ]=== */
