#!/usr/bin/python -tt

import os
import sys
import re
import urllib

import gtk
import hildondesktop

MAX_HEIGHT = 370. 
MAX_WIDTH = 700.

class XKCDha(hildondesktop.HomeItem):
	
    image_dir = "/home/user/MyDocs/.images/xkcdha/"
    icons_dir = "/usr/share/xkcdha/icons/"

    def __init__(self, max_height, max_width):
        def controls():
            hbox = gtk.HBox()
            hbox.pack_start(gtk.Alignment())
            for name in ("prev", "random", "next"):
                box = gtk.EventBox()
                image  = gtk.Image()
                image.set_from_file(self.icons_dir + "%s.png" % name)
                box.add(image)
                box.set_events(gtk.gdk.BUTTON_PRESS_MASK)
                box.connect("button-press-event", getattr(self, "cb_%s" % name))
                hbox.pack_start(box)
            hbox.pack_start(gtk.Alignment())
            return hbox

        hildondesktop.HomeItem.__init__(self)
        self.max_height, self.max_width = max_height, max_width
        self.number = None
        self.prev = None
        self.next = None
        self.image = gtk.Image()
		
        self.set_image()

        image_box = gtk.EventBox()
        image_box.add(self.image)
        image_box.set_events(gtk.gdk.BUTTON_PRESS_MASK)
        image_box.connect("button-press-event", self.cb_random)
	    	
        vbox = gtk.VBox()
        vbox.pack_start(controls())
        vbox.pack_start(image_box)
        vbox.pack_start(controls())
        vbox.show_all()

        self.add(vbox)

    def set_image(self, number=""):
        def get_image(number=""):
            
            if self.number and number != "random":
                if not number:
                    number = self.number
                elif number == "next" and self.next:
                    number = self.next
                if number == "prev" and self.prev:
                    number = self.prev

            print 'number=', number, self.number

            filename = os.path.join(self.image_dir, number + '.png')
            if os.path.exists(filename):
                print 'already exists', filename
                return filename

            url = "http://xkcd.com/"
            if number == 'random':
                url = "http://dynamic.xkcd.com/comic/random/"
            if number == 'next':
                url = url + self.next + '/'
            if number == 'prev':
                url = url + self.prev + '/'
            
            print 'url:', url

            content = urllib.urlopen(url).read()
            img_url = re.search('(http://imgs.xkcd.com/comics/[^"]+)" title="[^"]+"', 
                    content).group(1)
            next = re.search('<a href="([^"]+)" accesskey="n">Next', content).group(1)
            prev = re.search('<a href="([^"]+)" accesskey="p">&lt; Prev', content).group(1)
            self.number = re.search(\
                    '<h3>Permanent link to this comic: http://xkcd.com/([^/]+)/</h3>', 
                    content).group(1)
            self.next = self.number
            if next != '#':
                self.next = next[1:-1]

            self.prev = self.number
            if prev != '#':
                self.prev = prev[1:-1]

            filename = os.path.join(self.image_dir, self.number + '.png')
            if not os.path.exists(filename):
                urllib.urlretrieve(img_url, filename)
            
            print 'filename:', filename, 'img_url:', img_url
            print 'next:', next, self.next
            print 'prev:', prev, self.prev
            print 'number:', self.number
            return filename

        pixbuf = gtk.gdk.pixbuf_new_from_file(get_image(number))
        scale_y = self.max_height / pixbuf.props.height
        scale_x = self.max_width / pixbuf.props.width
        if scale_x > scale_y:
            newx = int(pixbuf.props.width * scale_y)
            newy = int(self.max_height)
        else:
            newx = int(self.max_width)
            newy = int(pixbuf.props.height * scale_x)
        
        self.image.set_from_pixbuf(pixbuf.scale_simple(newx, newy, gtk.gdk.INTERP_BILINEAR))
        self.image.show()

    def cb_random(self, widget, data = None):      
        self.set_image('random')

    def cb_next(self, widget, data = None):
        self.set_image('next')

    def cb_prev(self, widget, data = None):
         self.set_image('prev')

def hd_plugin_get_objects():
    return [XKCDha(MAX_HEIGHT, MAX_WIDTH)]

def run_in_window():
    main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
    main_window.set_title("XKCD Home Applet")
    main_window.connect("destroy", gtk.main_quit)
    main_window.add(XKCDha(MAX_HEIGHT, MAX_WIDTH))                            
    main_window.show_all()
    gtk.main()

if __name__ == "__main__":
    run_in_window()
    sys.exit()

