#ifndef HILDON_UTIL_H
#define HILDON_UTIL_H

#include <gdk/gdkevents.h>

#include <gtk/gtkwidget.h>
#include <gtk/gtkentry.h>

#include <hildon/hildon-program.h>
#include <hildon/hildon-window.h>

#include <libosso.h>

void hildon_util_program_initialize (void);

void hildon_util_program_deinitialize (void);

GtkWidget * hildon_util_window_new_and_add (void);

void hildon_util_add_window (HildonWindow *win);

void hildon_util_remove_window (HildonWindow *win);

void hildon_util_open_url (const char *url);

void hildon_util_disable_autocaps (GtkEntry *entry);

gboolean tap_and_hold_button_press_filter (GtkWidget *w, GdkEventButton *e);

void tap_and_hold_right_click_cb (GtkWidget *w, gpointer data);

#endif
