/*
 *
 * Wizard Monuter - 1.4
 *
 * @author		b0unc3
 * @date		31/10/2007
 * @last update		03/07/2009
 * @license		BSD
 *
 *
 */

#include <gtk/gtk.h>
#include <hildon/hildon-program.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <errno.h>
#include <libosso.h>


#define ICON_PATH		"/usr/share/icons/hicolor/scalable/hildon/"
#define SMB_IMG 		ICON_PATH"smb.png"
#define NFS_IMG 		ICON_PATH"nfs.png"
#define REFRESH_FOLDER 		ICON_PATH"refresh_folder.png"
#define COMMON_FLDR 		ICON_PATH"fldr.png"
#define MMC_FLDR 		ICON_PATH"mmc_fldr.png"
#define QM_ICON			ICON_PATH"qm.png"
#define BM_ICON			ICON_PATH"bm.png"
#define NFSPORT 		2049
#define NMBPORT 		139
#define SMBPORT 		445
#define MAXBUF 			1024
#define FS_PROC 		"/proc/filesystems"
#define MNT_PROC		"/proc/mounts"
#define PROFILE_DIR		"/home/user/.wm/"
#define WM_MOUNT_DIR		"/home/user/MyDocs/Remote_Filesystem/"
/* as suggest by Bobbie`s pathc */
#define USER_ID			29999
#define GROUP_ID		29999


enum
{
	COL_TEXT = 0,
	NUM_COLS
};


static const gchar 	*error;
static GtkWidget 	*lw;
static GtkWidget 	*edit_button;
static GtkWidget 	*del_button;
static GtkWidget 	*mnt_button;
static GtkWidget 	*umnt_button;

static GtkWidget	*show_addr;
static GtkWidget	*show_mp;
static GtkWidget	*show_type;

static void add_item();
static GtkWidget * create_view();
static void set_button_action(gboolean flag);

	

static
void message_dialog(int type, gchar *dialog_message)
{
	GtkWidget *dialog;
	
	if ( type == 1 ) {
		dialog = gtk_message_dialog_new(GTK_WINDOW(NULL),
				GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO, GTK_BUTTONS_OK,"%s\n",dialog_message);
	} else {
		dialog = gtk_message_dialog_new(GTK_WINDOW(NULL),
				GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,"%s\n",dialog_message);
	} 
	
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
}

static
gboolean found_client_support(char *service_name)
{
	FILE 	*f = NULL;
	char 	read_buffer[MAXBUF];

	f = fopen(FS_PROC,"r");
	if ( f != NULL ) {
		while(fgets(read_buffer,MAXBUF,f) != NULL ) {
			if ( strstr(read_buffer,service_name) != NULL ) {
				fclose(f);
				return TRUE;
			}
		}
	} 
	fclose(f);

	/* manually load the support */
	if ( strncasecmp(service_name,"nfs",3) == 0 ) { 
		/* check for portmap first */
		GError 	*error = NULL;
		gchar 	*out;
		gchar 	*err;
		gint 	exit;
		gchar 	error_buff[MAXBUF];
		if ( g_spawn_command_line_sync("/bin/pidof portmap",&out,&err,&exit,&error) ) {
			if ( out != NULL && strlen(out) < 2 ) {
				/* load portmap */
				out = err = NULL;
				error = NULL;
				if ( g_spawn_command_line_sync("/usr/bin/sudo /etc/init.d/portmap start",&out,&err,&exit,&error) ) {
					if ( strlen(err) > 2 ) {
						message_dialog(2,g_strdup_printf("Portmap not started!!\n%s",err));
						return FALSE;
					}
				} else {
					message_dialog(2,"Error on launching portmap daemon.\n");
				}

			} 
		}
		/* insmodding only the necessary module */
		if (   (system("/usr/bin/sudo /sbin/insmod /lib/modules/2.6.21-omap1/extra/sunrpc.ko")) != -1 
		    && (system("/usr/bin/sudo /sbin/insmod /lib/modules/2.6.21-omap1/extra/lockd.ko")) != -1
		    && (system("/usr/bin/sudo /sbin/insmod /lib/modules/2.6.21-omap1/extra/nfs.ko")) != -1 ) {
			return TRUE;
		} else {
			return FALSE;
		}
	} else if ( (strncasecmp(service_name,"smbfs",5) == 0) || ( strncasecmp(service_name,"cifs",4) == 0 ) ) {
		if (  system("/usr/bin/sudo /sbin/insmod /lib/modules/2.6.21-omap1/extra/cifs.ko") != -1 ) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	return FALSE;
}

static
gboolean found_service(char *servername, int port)
{
	int 			retsock,retconn;
	struct sockaddr_in 	server_addr;
	
	retsock = socket(AF_INET,SOCK_STREAM,0);
	if ( retsock == -1 ) {
		error = strerror(errno);
		return FALSE;
	} 
	
	server_addr.sin_family = AF_INET;
	memcpy(&server_addr.sin_addr, gethostbyname(servername)->h_addr, sizeof(server_addr.sin_addr));
	server_addr.sin_port = htons(port);

	retconn = connect(retsock, (struct sockaddr *) &server_addr, sizeof(server_addr));
	if ( retconn == -1 ) {
		error = strerror(errno);
		return FALSE;
	} 


	return TRUE;
}

static
gboolean mount ( gchar *server, gchar *remote_dir , int type, gchar *user, gchar *pwd ) 
{
	/*std for g_spawn*/
	GError 	*error = NULL;
	gchar 	*out;
	gchar 	*err;
	gint 	exit;
	gchar 	error_buff[MAXBUF];

	/** check for directory **/
	char 	*c;
	gchar 	*nstripped = NULL;
	gchar 	*mnt;
	gchar 	*dir = NULL;

	error_buff[0]='\0';
	nstripped = g_strdup(remote_dir);
	c = strstr(nstripped,"/");
	while(c!=NULL) {
		c[0] = '_';
		c = strstr(++c,"/");
	}
	if ( nstripped != NULL ) {
		dir = g_strdup_printf("%s%s@%s",WM_MOUNT_DIR,nstripped,server);
	} else {
		dir = g_strdup_printf("%s%s@%s",WM_MOUNT_DIR,remote_dir,server);
	}
	
	if ( !g_file_test(dir,G_FILE_TEST_IS_DIR ) ) {
		gchar *mk = g_strdup_printf("/bin/mkdir \"%s\"",dir);
		if ( g_spawn_command_line_sync(mk,&out,&err,&exit,&error) ) {
			if ( strlen(err) < 2 ) {
				g_strlcat(error_buff,"Directory succesfully created.\n",sizeof(error_buff));
			} else {
				message_dialog(2,g_strdup_printf("[mkdir] Ops! An error occured :\n %s\n",err));
				return FALSE;
			}
		} else {
			message_dialog(2,g_strdup_printf("[mkdir] Ops! An error occured :\n %s\n",err));
			return FALSE;
		}
	}
	err = NULL;
		
	if ( type == 1 ) {
		mnt = g_strdup_printf("/usr/bin/sudo /bin/mount -t nfs %s:\"%s\" %s", server,remote_dir, dir);
	} else {
		mnt = g_strdup_printf("/usr/bin/sudo /sbin/mount.cifs \"//%s/%s\" \"%s\" -o username=\"%s\",password=\"%s\",uid=%d,gid=%d\n",server,remote_dir,dir,user,pwd,USER_ID,GROUP_ID);
	}
	if ( g_spawn_command_line_sync(mnt,&out,&err,&exit,&error) ) {
		if ( strlen(err) < 2 ) {
			g_strlcat(error_buff,"Mounting Process Complete\n",sizeof(error_buff));
		} else {
			message_dialog(2,g_strdup_printf("[mount] Ops! An error occured :\n%s\n",err));
			return FALSE;
		}
	} else {
		message_dialog(2,g_strdup_printf("[mount] Ops! An error occured :\n%s\n",error->message));
		return FALSE;
	}
	
	message_dialog(1,error_buff);

	gtk_widget_set_sensitive(umnt_button,TRUE);

	return TRUE;
}

static gboolean
unload_bookmarks()
{
	/*std for g_spawn*/
	GError 		*error = NULL;
	gchar 		*out;
	gchar 		*err;
	gint 		exit;
	/*std for g_io* */
	GIOChannel 	*f = NULL;
	GIOStatus 	st;
	gchar 		*readbuf = NULL;

	f = g_io_channel_new_file(MNT_PROC,"r",NULL);

	if ( f!=NULL ) {
		while ( (st=g_io_channel_read_line(f,&readbuf,NULL,NULL,NULL) ) != G_IO_STATUS_EOF) {
			if ( g_strrstr(readbuf, "cifs") || g_strrstr(readbuf, "nfs") ) {
				char **split_it;
				split_it = g_strsplit(readbuf," ",5);
				gchar *umount = g_strdup_printf("/usr/bin/sudo /bin/umount \"%s\"",g_strcompress(split_it[1]));
				
				if ( g_spawn_command_line_sync(umount,&out,&err,&exit,&error) ) {
					if ( strlen(err) < 2 ) {
						message_dialog(1,"Umounting Process Complete\n");
					} else {
						message_dialog(2,g_strdup_printf("%s\n",err));
					} 
				} else {
					message_dialog(2,g_strdup_printf("%s\n",error->message));
				}
			}
			g_free(readbuf);
		}
		g_io_channel_close(f);
	}
	gtk_widget_set_sensitive(umnt_button,FALSE);

	return TRUE;
}

static
gboolean load_bookmarks()
{
	GtkTreeSelection *sel;
	GtkTreeModel	 *model;
	GtkTreeIter       selected_row;
	gchar 		 *data[10];
	GtkWidget 	 *label;
	GtkWidget	 *dialog = NULL;
	gint		 ret;
	
	sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(lw));
	
	g_assert(gtk_tree_selection_get_mode(sel) == GTK_SELECTION_SINGLE);
	
	if (gtk_tree_selection_get_selected(sel, &model, &selected_row))
	{
		gchar 		*str_data;
		
		gtk_tree_model_get (model, &selected_row, COL_TEXT, &str_data, -1);

		dialog = gtk_dialog_new();
		gtk_dialog_add_buttons(GTK_DIALOG(dialog),
				GTK_STOCK_YES, GTK_RESPONSE_OK,
				GTK_STOCK_NO, GTK_RESPONSE_CANCEL,
				NULL);
		
		label = gtk_label_new(g_strdup_printf("Loading  %s ? \n\n\n",str_data));
		gtk_container_add ( GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label);
		gtk_widget_show_all(GTK_WIDGET(dialog));

		ret = gtk_dialog_run(GTK_DIALOG(dialog));
		if ( ret == GTK_RESPONSE_CANCEL ) {
			gtk_widget_destroy(GTK_WIDGET(dialog));
			return FALSE;
		} else {
												
		/* load profile */
		GIOChannel 	*f = NULL;   
		GIOStatus 	st;   
		gchar 		*readbuf = NULL;
		int 		line=0;
		
		f = g_io_channel_new_file(g_strdup_printf("%s%s.profile",PROFILE_DIR,str_data),"r",NULL);
		
		if ( f!=NULL ) {
			while ( (st=g_io_channel_read_line(f,&readbuf,NULL,NULL,NULL) ) != G_IO_STATUS_EOF) {
				if ( line >= 1 && line <= 6 ) {
					data[line] = g_strdup(g_strchomp(readbuf));
				}
				g_free(readbuf);
				line++;
			}
			g_io_channel_close(f);
		} else {
			message_dialog(2,g_strdup_printf("Unable to open file : %s%s.profile\n",PROFILE_DIR,str_data));
			gtk_widget_destroy(GTK_WIDGET(dialog));
			return FALSE;
		}

					
		int type;
		if ( strncasecmp(data[4],"nfs",3) == 0 ) {
			type=1;
		} else {
			type=2;
		}
		if ( type == 1 ) {
			if ( found_service(g_strchomp(data[2]),NFSPORT) && found_client_support("nfs") ) { /*nfs mount*/
				mount(g_strchomp(data[2]),g_strchomp(data[3]),type,g_strchomp(data[5]),g_strchomp(data[6]));
			} else {
				if ( errno ) { 
					message_dialog(2,g_strdup(strerror(errno)));
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				} else {
					message_dialog(2,"client or server dosen't support nfs.\n");
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				}
			}
		} else {
			if ( (found_service(g_strchomp(data[2]),SMBPORT) && found_service(g_strchomp(data[2]),NMBPORT)) && (found_client_support("smbfs") || found_client_support("cifs")) ) {
				mount(g_strchomp(data[2]),g_strchomp(data[3]),type,g_strchomp(data[5]),g_strchomp(data[6]));
			} else {
				if ( errno ) {
					message_dialog(2,g_strdup(strerror(errno)));
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				} else {
					message_dialog(2,"client or server dosen't support samba.\n");
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				}
			}
		}
		}
	}

	if ( GTK_IS_WIDGET(dialog) ) gtk_widget_destroy(GTK_WIDGET(dialog));

	return TRUE;
}

static
gboolean rem_bookmarks(GtkWidget *widget)
{
	GtkTreeSelection *sel;
	GError 		 *error = NULL;
	gchar 		 *out;
	gchar 		 *err;
	gint 		 exit;
	GtkTreeModel     *model;
	GtkTreeIter       selected_row;
	GtkWidget 	 *dialog = NULL;
	GtkWidget 	 *label;
	gint 		 ret;
	
	sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(lw));
	
	g_assert(gtk_tree_selection_get_mode(sel) == GTK_SELECTION_SINGLE);
	
	if (gtk_tree_selection_get_selected(sel, &model, &selected_row))
	{
		gchar *str_data;
		gtk_tree_model_get (model, &selected_row, COL_TEXT, &str_data, -1);
		
		dialog = gtk_dialog_new();
		gtk_dialog_add_buttons(GTK_DIALOG(dialog),
					GTK_STOCK_YES, GTK_RESPONSE_OK,
					GTK_STOCK_NO, GTK_RESPONSE_CANCEL,
					NULL);
		label = gtk_label_new(g_strdup_printf("Deleting : %s\n\nAre you sure?\n",str_data));
		gtk_container_add ( GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label);
		gtk_widget_show_all(GTK_WIDGET(dialog));
		
		ret = gtk_dialog_run(GTK_DIALOG(dialog));
		if ( ret == GTK_RESPONSE_OK ) {
			gchar *rm = g_strdup_printf("/bin/rm %s\"%s\".profile\n",PROFILE_DIR,str_data); 
			if ( g_spawn_command_line_sync(rm,&out,&err,&exit,&error) ) {
				if ( strlen(err) > 2 ) {
					message_dialog(2, err);
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				} else {
					message_dialog(1, "Profile succesfully deleted.\n");
					gtk_list_store_remove(GTK_LIST_STORE(model), &selected_row);
				}
			} else {
				message_dialog(2, error->message);
				gtk_widget_destroy(GTK_WIDGET(dialog));
				return FALSE;
			}
		} else {
			gtk_widget_destroy(GTK_WIDGET(dialog));
			return FALSE;
		}
	}
	if ( GTK_IS_WIDGET(dialog) ) gtk_widget_destroy(GTK_WIDGET(dialog));

	return TRUE;
}

static
gboolean add_bookmarks(GtkWidget *widget,int mod)
{
	/*@fileds : profilename,server,remotedir,usr,pwd*/
	/*std for g_spawn */
	GError 	*error = NULL;
	gchar 	*err;
	gchar 	*out;
	gint 	exit;
	
	GtkWidget 	*dialog;
	GtkWidget 	*pname;
	GtkWidget 	*server;
	GtkWidget 	*remotedir;
	GtkWidget 	*usr;
	GtkWidget 	*pwd;
	GtkWidget 	*nfsb;
	GtkWidget 	*smbb;
	GSList 		*group;
	GtkWidget 	*box;
	GtkWidget 	*label;
	GtkWidget 	*mbox;
	gint 		res;
	
	GtkTreeSelection *sel;
	GtkTreeIter       selected_row;
	GtkTreeModel 	 *model;
	int 		 line=0;
	gchar 		 *str_data = NULL;

	dialog = gtk_dialog_new();
	gtk_dialog_add_buttons(GTK_DIALOG(dialog),
					GTK_STOCK_SAVE, GTK_RESPONSE_OK, 
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, 
					NULL);

	gtk_widget_set_usize(GTK_WIDGET(dialog),350,300); //375,350);

	mbox = gtk_vbox_new(FALSE,5);

	box = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Profile Name");
	pname = gtk_entry_new();
	gtk_box_pack_start ( GTK_BOX(box), label, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(box), pname, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(mbox), box, FALSE,FALSE,0 );

	box = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Server Address");
	server = gtk_entry_new();
	gtk_box_pack_start ( GTK_BOX(box), label, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(box), server, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(mbox), box, FALSE,FALSE,0 );

	box = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Remote Directory");
	remotedir = gtk_entry_new();
	gtk_box_pack_start ( GTK_BOX(box), label, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(box), remotedir, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(mbox), box, FALSE,FALSE,0 );

	box = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Username");
	usr = gtk_entry_new();
	gtk_box_pack_start ( GTK_BOX(box), label, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(box), usr, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(mbox), box, FALSE,FALSE,0 );

	box = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Password");
	pwd = gtk_entry_new();
	GTK_ENTRY(pwd)->visible = FALSE;
	gtk_box_pack_start ( GTK_BOX(box), label, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(box), pwd, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(mbox), box, FALSE,FALSE,0 );

	box = gtk_hbox_new(FALSE,2);
	nfsb = gtk_radio_button_new_with_label(NULL, "NFS");
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (nfsb));
	smbb = gtk_radio_button_new_with_label(group, "SAMBA");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (nfsb), TRUE);
	gtk_box_pack_start ( GTK_BOX(box), nfsb, TRUE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(box), smbb, TRUE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(mbox), box, TRUE,TRUE,0 );
	
	if ( mod == 1 ) {
		sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(lw));
		g_assert(gtk_tree_selection_get_mode(sel) == GTK_SELECTION_SINGLE);
		if (gtk_tree_selection_get_selected(sel, &model, &selected_row))
		{
			gtk_tree_model_get (model, &selected_row, COL_TEXT, &str_data, -1);

			GIOChannel 	*f = NULL;
			GIOStatus 	st;
			gchar 		*readbuf = NULL;

			f = g_io_channel_new_file(g_strdup_printf("%s%s.profile",PROFILE_DIR,str_data),"r",NULL);
			
			if ( f!=NULL ) {
				gtk_entry_set_text(GTK_ENTRY(pname), str_data);
				while ( (st=g_io_channel_read_line(f,&readbuf,NULL,NULL,NULL) ) != G_IO_STATUS_EOF) {
					readbuf[strlen(readbuf)-1] = '\0';
					switch(line) {
						case 2 : gtk_entry_set_text(GTK_ENTRY(server), readbuf);
							 break;
						case 3 : gtk_entry_set_text(GTK_ENTRY(remotedir), readbuf);
							 break;
						case 4 : if ( g_strrstr(readbuf,"NFS") ) { 
								 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nfsb),TRUE);
							 } else {
								 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(smbb),TRUE);
							 }
							 break;
						case 5 : gtk_entry_set_text(GTK_ENTRY(usr), readbuf); 
							 break;
						case 6 : gtk_entry_set_text(GTK_ENTRY(pwd), readbuf); 
							 break;
					}
					g_free(readbuf);
					line++;
				}
				g_io_channel_close(f);
			} else {
			       message_dialog(2,g_strdup_printf("Unable to open file : %s%s.profile\n",PROFILE_DIR,str_data));	
			       return FALSE;
			}
		} else {
			message_dialog(2,"Select a profile from the list before!\n");
			return FALSE;
		}
	}

	gtk_container_add ( GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), mbox);
	gtk_widget_show_all(GTK_WIDGET(dialog));

	res = gtk_dialog_run(GTK_DIALOG(dialog));
	if ( res == GTK_RESPONSE_OK ) {
		/*save profile*/
		/*@necessary : pname,server,remotedir */
		if ( strlen(gtk_entry_get_text(GTK_ENTRY(pname))) >= 1 && strlen(gtk_entry_get_text(GTK_ENTRY(server))) >= 1 && strlen(gtk_entry_get_text(GTK_ENTRY(remotedir))) >= 1 ) {
			if ( !g_file_test(PROFILE_DIR,G_FILE_TEST_IS_DIR) ) {
				gchar *mk = g_strdup_printf("/bin/mkdir %s\n",PROFILE_DIR);
				if ( g_spawn_command_line_sync(mk,&out,&err,&exit,&error) ) {
					if ( strlen(err) > 2 ) {
						message_dialog(2,g_strdup_printf("Error during dir creation : %s\n",err));
						gtk_widget_destroy(GTK_WIDGET(dialog));
						return FALSE;
					} 
				}
			}
			FILE *f = NULL;
			gchar *type = NULL;
			gchar *user = g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(usr)));
			gchar *pass = g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(pwd)));
			if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(nfsb)) ) {
				type = "NFS\n";
			} else {
				type = "SAMBA\n";
				if ( strlen(user) <= 1 && strlen(pass) <= 1 ) {
					message_dialog(2,"For using samba, username and password field are mandatory!!");
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				}
			}
			err = NULL;
			gchar *filename = g_strdup_printf("%s%s.profile",PROFILE_DIR,gtk_entry_get_text(GTK_ENTRY(pname)));
			g_debug("filename is %s\n",filename);
			if ( str_data != NULL ) {
				if ( g_file_test(g_strdup_printf("%s%s.profile",PROFILE_DIR,str_data),G_FILE_TEST_IS_REGULAR) ) {
					if ( g_spawn_command_line_sync(g_strdup_printf("/bin/rm %s\"%s\".profile\n",PROFILE_DIR,str_data),&out,&err,&exit,&error) ) {
						if ( strlen(err) > 2 ) {
							message_dialog(2,g_strdup_printf("Error during edit :  %s\n",err));
						} 
					} else {
						message_dialog(2,"Error during edit.\n");
					}
				} else {
					message_dialog(2,g_strdup_printf("Error : %s\"%s.profile\" is not a regular file.\n",PROFILE_DIR,str_data));
				}
			}

			f = fopen(filename,"w+");
			if ( f == NULL ) {
				message_dialog(2,"Error opening profile file!\n");
				gtk_widget_destroy(GTK_WIDGET(dialog));
				return FALSE;
			}
			fwrite(g_strdup_printf("[%s]\n",gtk_entry_get_text(GTK_ENTRY(pname))),strlen(g_strdup_printf("[%s]\n",gtk_entry_get_text(GTK_ENTRY(pname)))),1,f);
			fwrite(g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(pname))),strlen(g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(pname)))),1,f);
			fwrite(g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(server))),strlen(g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(server)))),1,f);
			fwrite(g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(remotedir))),strlen(g_strdup_printf("%s\n",gtk_entry_get_text(GTK_ENTRY(remotedir)))),1,f);
			fwrite(type,strlen(type),1,f);
			fwrite(user,strlen(user),1,f);
			fwrite(pass,strlen(pass),1,f);
			fwrite(g_strdup_printf("[/%s]\n",gtk_entry_get_text(GTK_ENTRY(pname))),strlen(g_strdup_printf("[/%s]\n",gtk_entry_get_text(GTK_ENTRY(pname)))),1,f);
			fclose(f);
			message_dialog(1,"Profile succesfully saved.\n");
			add_item();
		} else {
			message_dialog(2,"Field empty!!\n");
		}
	}

/*don't save*/
	if ( GTK_IS_WIDGET(dialog) ) gtk_widget_destroy(dialog);

	return TRUE;
}

static void
add_item()
{
	GtkTreeModel 	*model;
	GtkTreeIter 	row;
	GDir 		*d;
	int 		i=0;
	
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(lw));
	gtk_list_store_clear(GTK_LIST_STORE(model));
	d = g_dir_open(PROFILE_DIR,0,NULL);
	if ( d ) {
		const gchar *file;
		while ( (file=g_dir_read_name(d)) ) {
			if ( g_strrstr(file,".profile") != NULL ) {
				gtk_list_store_append(GTK_LIST_STORE(model), &row);
				gtk_list_store_set(GTK_LIST_STORE(model), &row, COL_TEXT, g_strdup(strtok((char *)file,".")), -1);
				i++;
			}
		}
	}
	if ( d!= NULL ) {
		set_button_action(TRUE);
		g_dir_close(d);
	} else if ( i == 0 ) {
		set_button_action(FALSE);
	} else {
		set_button_action(FALSE);
	}
}

static void
show_info()
{
	GtkTreeSelection *sel;
	GtkTreeIter       selected_row;
	GtkTreeModel 	 *model;
	int 		 line=0;
	gchar 		 *str_data;

	sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(lw));
	g_assert(gtk_tree_selection_get_mode(sel) == GTK_SELECTION_SINGLE);
	
	if (gtk_tree_selection_get_selected(sel, &model, &selected_row)) {
		gtk_tree_model_get (model, &selected_row, COL_TEXT, &str_data, -1);

		GIOChannel 	*f = NULL;
		GIOStatus 	st;
		gchar 		*readbuf = NULL;
		
		f = g_io_channel_new_file(g_strdup_printf("%s%s.profile",PROFILE_DIR,str_data),"r",NULL);
		
		if ( f!=NULL ) {
			while ( (st=g_io_channel_read_line(f,&readbuf,NULL,NULL,NULL) ) != G_IO_STATUS_EOF) {
				readbuf[strlen(readbuf)-1] = '\0';
				if ( line == 2 ) {
					//GTK_JUSTIFY_LEFT
					gtk_label_set_markup(GTK_LABEL(show_addr),g_strdup_printf("<b>%s</b>",readbuf));
					gtk_label_set_justify(GTK_LABEL(show_addr), GTK_JUSTIFY_RIGHT);
				} else if ( line == 3 ) {
					gtk_label_set_markup(GTK_LABEL(show_mp), g_strdup_printf("<b>%s</b>",readbuf));
					gtk_label_set_justify(GTK_LABEL(show_mp), GTK_JUSTIFY_RIGHT);
				} else if ( line == 4 ) {
					gtk_label_set_markup(GTK_LABEL(show_type), g_strdup_printf("<b>%s</b>",readbuf));
					gtk_label_set_justify(GTK_LABEL(show_type), GTK_JUSTIFY_RIGHT);
				}
				g_free(readbuf);
				line++;
			}
			g_io_channel_close(f);
		}
	}
}

static void
onSelectionChanged (GtkTreeSelection *sel, GtkListStore *liststore)
{
	        GtkTreeIter  selected_row;
		
		if (gtk_tree_selection_get_selected(sel, NULL, &selected_row)) {
			set_button_action(TRUE);
			show_info();
		} else {
			set_button_action(FALSE);
		}
}

static GtkWidget *
create_view()
{
	GtkCellRenderer    *renderer;
	GtkTreeViewColumn  *col;
	GtkTreeSelection   *sel;
	GtkListStore       *liststore;
	GtkWidget          *view;

	liststore = gtk_list_store_new(NUM_COLS, G_TYPE_STRING); /* NUM_COLS = 1*/     
	view = gtk_tree_view_new_with_model(GTK_TREE_MODEL(liststore));
	renderer = gtk_cell_renderer_text_new();
	col = gtk_tree_view_column_new();

	gtk_tree_view_column_pack_start(col, renderer, TRUE);
	gtk_tree_view_column_add_attribute(col, renderer, "text", COL_TEXT);
	gtk_tree_view_column_set_title(col, "Profiles");
	
	gtk_tree_view_append_column(GTK_TREE_VIEW(view), col);
	sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(sel, GTK_SELECTION_SINGLE);

	g_signal_connect ( G_OBJECT(sel), "changed", G_CALLBACK(onSelectionChanged), liststore);
	
	return view;
				
}

static
gboolean quick_mount (GtkWidget *widget) 
{
	GtkWidget *dialog;
	GtkWidget *sbox;
	GtkWidget *tbox;
	GtkWidget *abox;
	GtkWidget *label;
	GtkWidget *hlabel;
	GtkWidget *lbox;
	GtkWidget *mbox;
	GtkWidget *hbox;
	GtkWidget *servername;
	GtkWidget *remdir;
	GtkWidget *usr;
	GtkWidget *pwd;
	GtkWidget *nfs_box;
	GtkWidget *smb_box;
	GSList 	  *group;
	gint 	   ret;

	dialog = gtk_dialog_new();

	gtk_window_set_title (GTK_WINDOW(dialog), "Quick Mount");
	gtk_dialog_add_buttons (GTK_DIALOG(dialog),  GTK_STOCK_OK, GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);

	gtk_widget_set_usize(GTK_WIDGET(dialog),650,225);

	sbox = gtk_hbox_new(FALSE,2);
	lbox = gtk_vbox_new(FALSE,2);
	hbox = gtk_hbox_new(TRUE,2);
	mbox = gtk_vbox_new(FALSE,5);
	label = gtk_label_new("Server");
	hlabel = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(hlabel),"<span size=\"x-small\">Ip address or hostname</span>");
	servername = gtk_entry_new();
	gtk_box_pack_start ( GTK_BOX(hbox), label, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(hbox), servername, TRUE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hbox, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hlabel, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(sbox), lbox, FALSE, FALSE, 0 );

	lbox = gtk_vbox_new(FALSE,2);
	hbox = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Resources"); //mote Directory");
	hlabel = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(hlabel), "<span size=\"x-small\">Remote resource (directory) name</span>");
	remdir = gtk_entry_new();
	gtk_box_pack_start ( GTK_BOX(hbox), label, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(hbox), remdir, TRUE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hbox, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hlabel, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(sbox), lbox, FALSE, FALSE, 0 );

	abox = gtk_hbox_new(FALSE,2);
	lbox = gtk_vbox_new(FALSE,2);
	hbox = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Username");
	usr = gtk_entry_new();
	hlabel = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(hlabel), "<span size=\"x-small\">Username for authentication</span>");
	gtk_box_pack_start ( GTK_BOX(hbox), label, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(hbox), usr
			, TRUE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hbox, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hlabel, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(abox), lbox, FALSE, FALSE, 0 );

	lbox = gtk_vbox_new(FALSE,2);
	hbox = gtk_hbox_new(TRUE,2);
	label = gtk_label_new("Password");
	pwd = gtk_entry_new();
	GTK_ENTRY(pwd)->visible = FALSE;
	hlabel = gtk_label_new(NULL);
	gtk_label_set_markup(GTK_LABEL(hlabel), "<span size=\"x-small\">Password for authentication</span>");
	gtk_box_pack_start ( GTK_BOX(hbox), label, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(hbox), pwd, TRUE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hbox, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(lbox), hlabel, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(abox), lbox, FALSE, FALSE, 0 );

	tbox = gtk_hbox_new(TRUE,2);
	nfs_box = gtk_radio_button_new_with_label(NULL, "NFS");
	group = gtk_radio_button_group (GTK_RADIO_BUTTON (nfs_box));
	smb_box = gtk_radio_button_new_with_label(group, "SAMBA");
	gtk_box_pack_start ( GTK_BOX(tbox), nfs_box, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(tbox), smb_box, FALSE, FALSE, 0 );

	gtk_box_pack_start ( GTK_BOX(mbox), sbox, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(mbox), abox, FALSE, FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(mbox), tbox, FALSE, FALSE, 0 );

	gtk_container_add ( GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), mbox);

	gtk_widget_show_all(GTK_WIDGET(dialog));

	ret = gtk_dialog_run(GTK_DIALOG(dialog));
	
	if ( ret == GTK_RESPONSE_OK ) {
		/*what to mount ? */
		if ( strlen(gtk_entry_get_text(GTK_ENTRY(servername))) < 1 && strlen(gtk_entry_get_text(GTK_ENTRY(remdir))) < 1 ) {
			message_dialog(2,"Please fill in the server address and remote directory!\n");
			gtk_widget_destroy(GTK_WIDGET(dialog));
			return FALSE;
		} else {
		if ( GTK_TOGGLE_BUTTON (nfs_box)->active ) {
			/*nfs mount*/
				if ( found_service((char *)gtk_entry_get_text(GTK_ENTRY(servername)),NFSPORT) && found_client_support("nfs") ) {
					/* server support nfs && client too */
						mount((char *)gtk_entry_get_text(GTK_ENTRY(servername)),(char *)gtk_entry_get_text(GTK_ENTRY(remdir)),1,NULL,NULL);

				} else {
					if ( !found_service((char *)gtk_entry_get_text(GTK_ENTRY(servername)),NFSPORT) ) {
						message_dialog(2,g_strdup_printf ("Server %s NFS Support ... \t%s.\n",gtk_entry_get_text(GTK_ENTRY(servername)),error));
						gtk_widget_destroy(GTK_WIDGET(dialog));
						return FALSE;
					}
					if ( !found_client_support("nfs") ) {
						message_dialog(2,"Client NFS Support ... \tnot found.\n");
						gtk_widget_destroy(GTK_WIDGET(dialog));
						return FALSE;
					}
				}
		} else if ( GTK_TOGGLE_BUTTON (smb_box)->active ) {
			/*samba mount */
			if ( (found_service((char *)gtk_entry_get_text(GTK_ENTRY(servername)),SMBPORT) 
					&& found_service((char *)gtk_entry_get_text(GTK_ENTRY(servername)),NMBPORT))
					&& (found_client_support("smbfs") || found_client_support("cifs")) ) {
				mount((char *)gtk_entry_get_text(GTK_ENTRY(servername)),(char *)gtk_entry_get_text(GTK_ENTRY(remdir)),2,(char *)gtk_entry_get_text(GTK_ENTRY(usr)),(char *)gtk_entry_get_text(GTK_ENTRY(pwd)));
			} else {
				if ( !found_service((char *)gtk_entry_get_text(GTK_ENTRY(servername)),SMBPORT) || !found_service((char *)gtk_entry_get_text(GTK_ENTRY(servername)),NMBPORT) ) {
					message_dialog(2,g_strdup_printf("Server %s SAMBA Support ... \t%s\n",gtk_entry_get_text(GTK_ENTRY(servername)),error));
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				}
				if ( !found_client_support("smbfs") || !found_client_support("cifs") ) {
					message_dialog(2,"Client SAMBA Support ... \tnot found.\n");
					gtk_widget_destroy(GTK_WIDGET(dialog));
					return FALSE;
				}
			}

		}
	}
	}

	if ( GTK_IS_WIDGET(dialog) ) gtk_widget_destroy(GTK_WIDGET(dialog));

	return TRUE;
}

static gboolean
something_mounted()
{
	GIOChannel 	*f = NULL;
	GIOStatus 	st;
	gchar 		*readbuf = NULL;
	
	f = g_io_channel_new_file(MNT_PROC,"r",NULL);
	
	if ( f!=NULL ) {
		while ( (st=g_io_channel_read_line(f,&readbuf,NULL,NULL,NULL) ) != G_IO_STATUS_EOF) {
			if ( g_strrstr(readbuf, "cifs") || g_strrstr(readbuf, "nfs") ) {
				return TRUE;
			}
			g_free(readbuf);
		}
		g_io_channel_close(f);
	}

	return FALSE;
}

static void
set_button_action(gboolean flag) 
{
	gtk_widget_set_sensitive(edit_button,flag);
	gtk_widget_set_sensitive(del_button,flag);
	gtk_widget_set_sensitive(mnt_button,flag);
}

int main(int argc, char *argv[]) 
{
	HildonProgram 	*program;
	HildonWindow 	*window;
	GtkWidget 	*main_box;
	GtkWidget 	*hbox;
	GtkWidget 	*qm;
	GtkWidget 	*quit;
	GtkWidget 	*label;
	GtkWidget 	*sw;
	GtkWidget 	*abox;
	
	GtkWidget 	*bbox;
	GtkWidget	*add_button;
	GtkWidget	*f3;
	GtkWidget	*show_box;
	//,/**del_button,*edit_button,*mnt_button,*/
	GtkWidget	*f1;
	GtkWidget	*f2;
	GtkWidget	*img;
	GtkWidget	*bbox2;
	GtkWidget	*def_box;
	GtkWidget	*hbbox;
	osso_context_t 	*osso_context;

	/* Initialize maemo application */
	osso_context = osso_initialize("wizard_mounter", "1.1.0", TRUE, NULL);
	       
	/* Check that initialization was ok */
	if (osso_context == NULL)
	{
		    return OSSO_ERROR;
	}

	gtk_init(&argc,&argv);

	if ( !g_file_test(WM_MOUNT_DIR,G_FILE_TEST_IS_DIR) ) {
		if ( system("/bin/mkdir /home/user/MyDocs/Remote_Filesystem") == -1 ) return -1;
	}

	program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name("Wizard Mounter 1.1");
	
	window = HILDON_WINDOW(hildon_window_new());
	hildon_program_add_window(program, window);

	main_box = gtk_hbox_new(FALSE,2);
	quit = gtk_button_new_from_stock(GTK_STOCK_QUIT);
	def_box = gtk_hbutton_box_new();
	hbbox = gtk_hbutton_box_new();
	bbox = gtk_vbutton_box_new();
	bbox2 = gtk_vbutton_box_new();
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_START);

	add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
	edit_button = gtk_button_new_from_stock(GTK_STOCK_EDIT);
	del_button = gtk_button_new_from_stock(GTK_STOCK_REMOVE);
	qm = gtk_button_new(); //_with_label("Quick Mount");
	hbox = gtk_hbox_new(FALSE,2);
	label = gtk_label_new("Quick Mount");
	gtk_container_add ( GTK_CONTAINER(qm), hbox);
	img = gtk_image_new_from_stock(GTK_STOCK_EXECUTE, GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_box_pack_start ( GTK_BOX(hbox), img, TRUE,TRUE,0);
	gtk_box_pack_start ( GTK_BOX(hbox), label, TRUE,TRUE,0);

	mnt_button = gtk_button_new(); 
	hbox = gtk_hbox_new(FALSE,2);
	label = gtk_label_new("Mount");
	gtk_container_add ( GTK_CONTAINER(mnt_button), hbox);
	img = gtk_image_new_from_stock(GTK_STOCK_CONNECT, GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_box_pack_start ( GTK_BOX(hbox), img, TRUE,TRUE,0);
	gtk_box_pack_start ( GTK_BOX(hbox), label, TRUE,TRUE,0);

	umnt_button = gtk_button_new();

	hbox = gtk_hbox_new(FALSE,2);
	label = gtk_label_new("Umount");
	gtk_container_add ( GTK_CONTAINER(umnt_button), hbox);
	img = gtk_image_new_from_stock(GTK_STOCK_DISCONNECT, GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_box_pack_start ( GTK_BOX(hbox), img, TRUE, TRUE, 0);
	gtk_box_pack_start ( GTK_BOX(hbox), label, TRUE, TRUE, 0);
	if ( !something_mounted() ) {
		gtk_widget_set_sensitive(umnt_button, FALSE);
	}
	
	quit = gtk_button_new_from_stock(GTK_STOCK_QUIT);

	f1 = gtk_frame_new("Quick Operations");
	gtk_container_add (GTK_CONTAINER (bbox2), qm);
	gtk_container_add (GTK_CONTAINER (bbox2), quit);
	gtk_container_add (GTK_CONTAINER(f1),bbox2);

	abox = gtk_vbox_new(FALSE,2);

	f2 = gtk_frame_new("Manage Bookmarks");
	gtk_container_add (GTK_CONTAINER (def_box), add_button);
	gtk_container_add (GTK_CONTAINER (def_box), del_button);
	gtk_container_add (GTK_CONTAINER (def_box), edit_button);

	gtk_button_box_set_layout (GTK_BUTTON_BOX (def_box), GTK_BUTTONBOX_EDGE);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (hbbox), GTK_BUTTONBOX_EDGE);
	gtk_container_add (GTK_CONTAINER (hbbox), mnt_button);
	gtk_container_add (GTK_CONTAINER (hbbox), umnt_button);

	gtk_container_add (GTK_CONTAINER (bbox), def_box);
	gtk_container_add (GTK_CONTAINER (bbox), hbbox);
	gtk_container_add (GTK_CONTAINER (f2), bbox);

	f3 = gtk_frame_new("Selected Profile Information");
	show_box = gtk_table_new(3,3,FALSE); //gtk_vbox_new(TRUE,3);
	show_addr = gtk_label_new(NULL);
	show_mp = gtk_label_new(NULL);
	show_type = gtk_label_new(NULL);
	gtk_table_attach_defaults(GTK_TABLE(show_box), gtk_label_new("Server Address"), 0,1,0,1);
	gtk_table_attach_defaults(GTK_TABLE(show_box), show_addr, 1,2,0,1);
	gtk_table_attach_defaults(GTK_TABLE(show_box), gtk_label_new("Remote Resource"), 0,1,1,2);
	gtk_table_attach_defaults(GTK_TABLE(show_box), show_mp, 1,2,1,2);
	gtk_table_attach_defaults(GTK_TABLE(show_box), gtk_label_new("Type"), 0,1,2,3);
	gtk_table_attach_defaults(GTK_TABLE(show_box), show_type, 1,2,2,3);
/*	gtk_box_pack_start ( GTK_BOX (show_box), show_addr, TRUE, TRUE, 0);
	gtk_box_pack_start ( GTK_BOX (show_box), show_mp, TRUE, TRUE, 0);
	gtk_box_pack_start ( GTK_BOX (show_box), show_type, TRUE, TRUE, 0);*/
	gtk_container_add ( GTK_CONTAINER(f3), show_box);

	sw = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
			GTK_POLICY_AUTOMATIC,
			GTK_POLICY_AUTOMATIC);

	lw = create_view ();
	add_item();
	set_button_action(FALSE);
	
	gtk_container_add(GTK_CONTAINER(sw), lw);

	gtk_box_pack_start ( GTK_BOX(abox), f1, FALSE,FALSE,0 );        
	gtk_box_pack_start ( GTK_BOX(abox), f2, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(abox), f3, TRUE,TRUE,0 );

	gtk_box_pack_start ( GTK_BOX(main_box), sw, TRUE,TRUE,0);
	gtk_box_pack_start ( GTK_BOX(main_box), abox, FALSE,FALSE,0);

	g_signal_connect ( G_OBJECT(qm), "clicked", G_CALLBACK(quick_mount), NULL);
	g_signal_connect ( G_OBJECT(add_button), "clicked", G_CALLBACK(add_bookmarks), (gpointer)0);
	g_signal_connect ( G_OBJECT(edit_button), "clicked", G_CALLBACK(add_bookmarks), (gpointer)1);
	g_signal_connect ( G_OBJECT(del_button), "clicked", G_CALLBACK(rem_bookmarks), NULL);
	g_signal_connect ( G_OBJECT(mnt_button), "clicked", G_CALLBACK(load_bookmarks), NULL);
	g_signal_connect ( G_OBJECT(umnt_button), "clicked", G_CALLBACK(unload_bookmarks), NULL);
	g_signal_connect ( G_OBJECT(quit), "clicked", G_CALLBACK(gtk_main_quit), NULL);
	g_signal_connect ( G_OBJECT(window), "delete_event", G_CALLBACK(gtk_main_quit), NULL);


	gtk_container_add ( GTK_CONTAINER(window), main_box );

	gtk_widget_show_all ( GTK_WIDGET(window));

	gtk_main();

	return 0;
}

