/*
  WifiInfo - Show current Wifi sttaus
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "StatusHildon.h"

#include <Lum/OS/X11/Display.h>

#include <iostream>

DBusHandlerResult DBusMsgHandler(DBusConnection *connection, DBusMessage *msg, void *data)
{
  StatusHildon *statusHildon=static_cast<StatusHildon*>(data);

  if (statusHildon->HandleMessage(connection,msg)) {
    return DBUS_HANDLER_RESULT_HANDLED;
  }
  else {
    return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
  }
}

void callback(DBusPendingCall* /*call*/, void* /*data*/)
{
  std::cout << "Got response!" << std::endl;
}

StatusHildon::StatusHildon()
{
  dbus_connection_add_filter(GetDBusConnection(),DBusMsgHandler,this,NULL);
}

DBusConnection* StatusHildon::GetDBusConnection()
{
  return dynamic_cast<Lum::OS::X11::Display*>(Lum::OS::display)->dbusSystem;
}

bool StatusHildon::HandleMessage(DBusConnection *connection, DBusMessage *msg)
{
  if (dbus_message_get_type(msg)==DBUS_MESSAGE_TYPE_METHOD_CALL) {
    DBusMessage *response;
    std::string appName;
    std::string error;

    response=dbus_message_new_error(msg,"Message not implemented","Message not implemented");
    dbus_connection_send(connection,response,NULL);
    dbus_message_unref(response);
    return true;
  }
  else if (dbus_message_get_type(msg) == DBUS_MESSAGE_TYPE_SIGNAL) {
    if (strcmp(dbus_message_get_interface(msg),"com.nokia.wlancond.signal")!=0 ||
        strcmp(dbus_message_get_path(msg),"/com/nokia/wlancond/signal")!=0 ||
        strcmp(dbus_message_get_member(msg),"scan_results")!=0) {
      return false;
    }
  }
  else {
    return false;
  }

  DBusMessageIter iter;
  int             type;

  dbus_message_iter_init(msg,&iter);
  while ((type=dbus_message_iter_get_arg_type(&iter))!=DBUS_TYPE_INVALID) {

    std::cout << "Type: " << (char)dbus_message_iter_get_arg_type(&iter) << std::endl;

    if (dbus_message_iter_get_arg_type(&iter)==DBUS_TYPE_STRING) {
      const char* value;

      dbus_message_iter_get_basic(&iter,&value);
      std::cout << "'" << value << "'" << std::endl;
    }
    if (type==DBUS_TYPE_ARRAY) {
      DBusMessageIter iter2;

      dbus_message_iter_recurse(&iter,&iter2);
      while ((type=dbus_message_iter_get_arg_type(&iter2))!=DBUS_TYPE_INVALID) {

        std::cout << "  Type: " << (char)dbus_message_iter_get_arg_type(&iter2) << std::endl;

        if (type==DBUS_TYPE_BYTE) {
          char value;

          dbus_message_iter_get_basic(&iter2,&value);

          std::cout << value << std::endl;
        }

        dbus_message_iter_next(&iter2);
      }
    }

    dbus_message_iter_next(&iter);
  }

  return true;
}

bool StatusHildon::SupportsNetworkRetrieval() const
{
  return true;
}

bool StatusHildon::UpdateNetworks()
{
  DBusMessage     *msg;
  DBusPendingCall *call;
  dbus_int32_t    power=4;
  dbus_int32_t    flags=2;
  unsigned char   a[] = { 0 };
  unsigned char*  ap=a;

  std::cout << "Sending call..." << std::endl;

  msg=dbus_message_new_method_call("com.nokia.wlancond",
                                   "/com/nokia/wlancond/request",
                                   "com.nokia.wlancond.request",
                                   "scan");

  dbus_message_append_args(msg,
                           DBUS_TYPE_INT32,&power,
                           DBUS_TYPE_ARRAY,DBUS_TYPE_BYTE,&ap,0,
                           DBUS_TYPE_UINT32,&flags,
                           DBUS_TYPE_INVALID);

  if (!dbus_connection_send_with_reply(GetDBusConnection(),msg,&call,-1)) {
    std::cout << "Cannot send with reply" << std::endl;
    return false;
  }

  dbus_pending_call_set_notify(call,callback,NULL,NULL);

  std::cout << "Sending call done." << std::endl;

  return false;

  return true;
}
