#!/usr/bin/env python

import sys
import os
import time
import re
import operator
try:
	import pygtk
	pygtk.require("2.0")
except:
	pass
try:
	import gtk
	import gtk.glade
except:
	sys.exit(1)

class WeightWatchers:
	
	def __init__(self):
		if os.path.isfile("/usr/local/lib/weightwatchers.glade") :
			self.gladefile = "/usr/local/lib/weightwatchers.glade"  
		elif os.path.isfile("./weightwatchers.glade") :
			self.gladefile = "./weightwatchers.glade"  

		self.wTree = gtk.glade.XML(self.gladefile)
		self.window = self.wTree.get_widget("window1")
		if (self.window):
			self.window.connect("destroy", gtk.main_quit)
		
		self.points = self.wTree.get_widget("entry_points")
		self.calories = self.wTree.get_widget("spin_calories")
		self.fat = self.wTree.get_widget("spin_fat")
		self.fiber = self.wTree.get_widget("spin_fiber")

		self.about_dialog = None  #-- Not sure if I need these two
		self.error_dialog = None  #-- lines...

		dic = {
			# Process signal from button
			"calculate" : self.calculate_points}
		self.wTree.signal_autoconnect(dic)
	
	
	def ErrPopUp(self,msg):
		error_dialog = gtk.MessageDialog(None,0,gtk.MESSAGE_ERROR,gtk.BUTTONS_CLOSE,msg)
		def close(dialog, response, editor):
			editor.about_dialog = None
			dialog.destroy()
		error_dialog.connect("response", close, self)
		# error_dialog.connect("delete-event", delete_event, self)
		self.error_dialog = error_dialog
		error_dialog.run()
	
		
	def calculate_points(self, widget):
		self.points.set_text(str(operator.sub(operator.add(operator.div(self.calories.get_value_as_int(), 50),operator.div(self.fat.get_value_as_int(),12)),operator.div(self.fiber.get_value_as_int(),5))))
		
		
	
if __name__ == "__main__":
	title = 'Weight Watches Calculator'
	handle = WeightWatchers()
	gtk.main()
	sys.exit(1)
