/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2008  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/ActionDialog.h>

#include <Lum/Model/String.h>

class Preferences : public Lum::Dlg::ActionDialog
{
private:
  Lum::Model::ActionRef okAction;

  Lum::Model::StringRef topWeight;
  Lum::Model::StringRef bottomWeight;
  Lum::Model::StringRef maxWeight;
  Lum::Model::StringRef minWeight;

  Lum::Model::StringRef topValue;
  Lum::Model::StringRef bottomValue;
  Lum::Model::StringRef maxValue;
  Lum::Model::StringRef minValue;
  Lum::Model::StringRef goodValueLimit;
  Lum::Model::StringRef badValueLimit;

  Lum::Model::StringRef refValue;

  Lum::Model::StringRef valueUnit;
  Lum::Model::StringRef weightUnit;

public:
  Preferences();
  ~Preferences();

  Lum::Object* GetContent();
  void GetActions(std::vector<Lum::Dlg::ActionInfo>& actions);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};
