/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2008  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Trend.h"

static Trend::Prefs *prefs=new Trend::Prefs();

Trend::Trend()
 : noneColor(0.5,0.5,0.5,Lum::OS::display->GetColor(Lum::OS::Display::whiteColor)),
   upColor(0,1,0,Lum::OS::display->GetColor(Lum::OS::Display::fillColor)),
   downColor(1,0,0,Lum::OS::display->GetColor(Lum::OS::Display::whiteColor))
{
  SetPrefs(::prefs);
}

Trend::~Trend()
{
  // no code
}

bool Trend::SetModel(Lum::Base::Model* model)
{
  this->model=dynamic_cast<Lum::Model::Int*>(model);

  Lum::Control::SetModel(this->model);

  return this->model.Valid();
}

void Trend::CalcSize()
{
  minWidth=Lum::OS::display->GetFont()->height;
  minHeight=minWidth;

  width=minWidth;
  height=minHeight;

  Control::CalcSize();
}

void Trend::Draw(int x, int y, size_t w, size_t h)
{
  Lum::Control::Draw(x,y,w,h);

  if (!Intersect(x,y,w,h)) {
    return;
  }

  /* --- */

  DrawBackground(x,y,w,h);

  Lum::OS::DrawInfo *draw=GetDrawInfo();

  draw->PushForeground(Lum::OS::Display::blackColor);
  if (!model.Valid() || model->IsNull()) {
    draw->PushForeground(noneColor);
  }
  else {
    switch (model->Get()) {
    case none:
      draw->PushForeground(noneColor);
      break;
    case up:
      draw->PushForeground(upColor);
      break;
    case down:
      draw->PushForeground(downColor);
      break;
    default:
      assert(false);
    }
  }

  draw->FillArc(this->x,this->y,width,height,0,360*64);
  draw->PopForeground();

  draw->DrawArc(this->x,this->y,width,height,0,360*64);
  draw->PopForeground();
}

void Trend::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (visible && model==this->model) {
    Redraw();
  }

  Lum::Control::Resync(model,msg);
}

