/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2008  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Help.h"

#include <Lum/Base/L10N.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Edit/Edit.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>
#include <Lum/View.h>
#include <Lum/WindowGroup.h>

#define HELP_TEXT L"WeightJinni Help\n"\
L"\n"\
L"WeightJinni has two main views realized by two tabs.\n"\
L"\n"\
L"The first tab again is splitted into two ares, the\n"\
L"left side and the right side.\n"\
L"\n"\
L"On the left side you can collect various items of\n"\
L"food. For every food item you can give a unit (gramm,\n"\
L"spoonful, pice or similar) and you can give it a value\n"\
L"or rating. A simple rating would be the kcal or joule\n"\
L"for the given portion. But there are other units\n"\
L"possible like for example the unit of some well known\n"\
L"organisation helping people watching for their\n"\
L"weight :-)\n"\
L"\n"\
L"Currently there is no preset data for this. The problem\n"\
L"is that my currently only user uses data that is\n"\
L"protected by copyright and ths cannot be shared. If\n"\
L"somebody has a source for non-copyright proteced\n"\
L"material, I can generate a preset file for this. Note\n"\
L"that you can import end export this data, so once you\n"\
L"have some data, you can share it.\n"\
L"\n"\
L"The left table has a popup menu that can be activated\n"\
L"by pointing and holding. Themenu items should be\n"\
L"obvious.\n"\
L"\n"\
L"Note that the rating can be independent of the amount\n"\
L"of food (choose a specific unit for this). Also note\n"\
L"that rating can be negative, so jogging is a special\n"\
L"kind of negative food!\n"\
L"\n"\
L"On the right side you have a log of the food you have\n"\
L"been eating at that date together with your weight.\n"\
L"Use the date chooser to scroll through the days. Use\n"\
L"the popup menu for this table to add weight, edit\n"\
L"entries and so on.\n"\
L"\n"\
L"Double clicking on a food on the left side poups a\n"\
L"dialog asking for the used amount and then adds this\n"\
L"to the right table.\n"\
L"\n"\
L"The diagram shows your weight over time and also shows\n"\
L"the sum of rating per day as a bar. Stroking up or down\n"\
L"on the graph changes units. Double clicking on a date\n"\
L"jumps to that date.\n"\
L"\n"\
L"The preferences dialog now allows you to adjust some\n"\
L"stuff:\n"\
L"You can enter the minimum rate and maximum rate and\n"\
L"also the minimum and maximum wieght displayed in the\n"\
L"graph.\n"\
L"You can enter minimum and maximum recemmended values\n"\
L"for rating per day and weight. Values within this\n"\
L"range will be marked black, values outside will be\n"\
L"marked red. You will also get some red ticks to the\n"\
L"left and right of the diagram.\n"\
L"You can also define limits for good and bad food. Good\n"\
L"food (with low rating) will be marked green, bad food\n"\
L"(with bad rating) will bemarked red. Currently you must\n"\
L"adjust the unit for the food to get this to work fine.\n"\
L"\n"\
L"You can define the units for the rating (kcal or joule)\n"\
L"and the weight (Kg or pounds).\n"\
L"Beside the date chooser are two values: The first one\n"\
L"gives you the different in average weight of the last\n"\
L"seven days incomparison of the seven days before this\n"\
L"seven days. The second one shows the used rating and\n"\
L"the left rating per day, relative to the upper limit\n"\
L"as defined by preferences.\n"\
L"\n"\
L"I plan to further improve the application.\n"\
L"\n"\
L"P.S.:I can also offer a Linux desktop version and a\n"\
L"Windows desktop version."

Help::Help()
{
  SetExitAction(GetClosedAction());
}

Help::~Help()
{
  // no code
}

void Help::PreInit()
{
  Lum::Button      *button;
  Lum::ButtonRow   *buttonRow;
  Lum::Edit::Edit  *edit;
  Lum::Edit::Text  *editContent;
  Lum::Panel       *panel;
  Lum::View        *view;
  Lum::WindowGroup *windowGroup;

  panel=new Lum::VPanel();
  panel->SetFlex(true,true);
  panel->SetMinHeight(Lum::Base::Size::workVRel,20);
  panel->SetHeight(Lum::Base::Size::workVRel,60);

  editContent=new Lum::Edit::Text();
  editContent->SetText(_(L"HELP_CONTENT",HELP_TEXT));
  editContent->Disable();

  view=new Lum::View();
  view->SetFlex(true,true);

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,80);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  view->SetObject(edit);

  panel->Add(view);

  panel->Add(new Lum::VSpace());

  buttonRow=new Lum::ButtonRow();
  buttonRow->SetFlex(true,false);

  button=new Lum::Button();
  button->SetFlex(true,true);
  button->SetModel(GetClosedAction());
  button->SetType(Lum::Button::typeDefault);
  button->SetText(_ld(dlgButtonClose));
  buttonRow->Add(button);

  panel->Add(buttonRow);

  windowGroup=new Lum::WindowGroup();
  windowGroup->SetMain(panel);

  SetTop(windowGroup);

  Dialog::PreInit();
}

void Help::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  Dialog::Resync(model,msg);
}
