#ifndef DATAINPUT_H
#define DATAINPUT_H

/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>
#include <Lum/Model/Time.h>

class DataInput : public Lum::Component
{
public:
  class Prefs : public Lum::Component::Prefs
  {
  public:
    Prefs();
    void Initialize();
  };

private:
  Lum::Model::ActionRef              prevDayAction;
  Lum::Model::ActionRef              todayAction;
  Lum::Model::ActionRef              nextDayAction;

  Lum::Model::ActionRef              addFoodAction;
  Lum::Model::ActionRef              removeFoodAction;
  Lum::Model::ActionRef              editFoodAction;
  Lum::Model::ActionRef              registerFoodAction;

  Lum::Model::ActionRef              addWeightAction;
  Lum::Model::ActionRef              removeItemAction;
  Lum::Model::ActionRef              editItemAction;

  Lum::Model::StringRef              foodSearch;
  Lum::Model::StringRef              averageDiff;
  Lum::Model::StringRef              summary;
  Lum::Model::TimeRef                time;
  Lum::Model::ListTableRef           foods;
  Lum::Model::ListTableRef           entries;
  Lum::Model::SingleLineSelectionRef foodSelection;
  Lum::Model::SingleLineSelectionRef entrySelection;
  std::wstring                       lastFoodSearchFilter;
  Lum::Model::ActionRef              searchTimerAction;

private:
  void UpdateEntries();
  void UpdateSummary();

  void AddFood();
  void EditFood();
  void RemoveFood();
  void RegisterFood();

  void AddWeight();
  void RemoveItem();
  void EditItem();

public:
  DataInput();
  ~DataInput();

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

  void InitializeGUI();
  void UpdateFoods();
};

#endif
