#! /bin/sh
dbus_msg()
{
dbus-send --print-reply --type=method_call \
 --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
 org.freedesktop.Notifications.SystemNoteDialog \
 string:"$1" \
 uint32:$2 string:'OK'
}

exit_wayv()
{
dbus_msg "Configuration file reloading succeeded." 2
if [ $ED = 1 ] ; then
 dbus_msg "Can't find leafpad/osso_notes/emacs/vi. Edit /home/user/.wayv.skippy.conf." 0
 exit 1
else
 exit 0
fi
}

ED=0
SCONF=/home/user/.wayv.skippy.conf
if [ ! -e $SCONF ] ;then
 dbus_msg "Can't find $SCONF. Please reinstall wayV" 1
 exit 1
fi
if [ -e /usr/bin/leafpad ] ;then
	leafpad $SCONF
elif [ -e /usr/bin/osso_notes ] ;then
	dbus-send --print-reply --dest=com.nokia.osso_notes \
	 /com/nokia/osso_notes com.nokia.osso_notes.mime_open \
	 string:"$SCONF"
elif [ -e /usr/bin/osso-xterm ] ;then
	if [ -e /usr/bin/emacs ] ;then
		osso-xterm -e 'emacs $SCONF'
	elif [ -e /bin/vi ] ;then
		osso-xterm -e 'vi $SCONF'
	else
		ED=1
	fi
else
ED=1
fi

exit_wayv

