/* valaccodetypedefinition.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_TYPE_DEFINITION (vala_ccode_type_definition_get_type ())
#define VALA_CCODE_TYPE_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinition))
#define VALA_CCODE_TYPE_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinitionClass))
#define VALA_IS_CCODE_TYPE_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_TYPE_DEFINITION))
#define VALA_IS_CCODE_TYPE_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_TYPE_DEFINITION))
#define VALA_CCODE_TYPE_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinitionClass))

typedef struct _ValaCCodeTypeDefinition ValaCCodeTypeDefinition;
typedef struct _ValaCCodeTypeDefinitionClass ValaCCodeTypeDefinitionClass;
typedef struct _ValaCCodeTypeDefinitionPrivate ValaCCodeTypeDefinitionPrivate;

#define VALA_TYPE_CCODE_DECLARATOR (vala_ccode_declarator_get_type ())
#define VALA_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclarator))
#define VALA_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))
#define VALA_IS_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_IS_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_CCODE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))

typedef struct _ValaCCodeDeclarator ValaCCodeDeclarator;
typedef struct _ValaCCodeDeclaratorClass ValaCCodeDeclaratorClass;

#define VALA_TYPE_CCODE_LINE_DIRECTIVE (vala_ccode_line_directive_get_type ())
#define VALA_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirective))
#define VALA_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))
#define VALA_IS_CCODE_LINE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_IS_CCODE_LINE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_LINE_DIRECTIVE))
#define VALA_CCODE_LINE_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectiveClass))

typedef struct _ValaCCodeLineDirective ValaCCodeLineDirective;
typedef struct _ValaCCodeLineDirectiveClass ValaCCodeLineDirectiveClass;

/**
 * Represents a node in the C code tree.
 */
struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

/**
 * Represents a typedef in the C code.
 */
struct _ValaCCodeTypeDefinition {
	ValaCCodeNode parent_instance;
	ValaCCodeTypeDefinitionPrivate * priv;
};

struct _ValaCCodeTypeDefinitionClass {
	ValaCCodeNodeClass parent_class;
};

struct _ValaCCodeTypeDefinitionPrivate {
	char* _type_name;
	ValaCCodeDeclarator* _declarator;
};



gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void);
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void);
GType vala_ccode_type_definition_get_type (void);
GType vala_ccode_declarator_get_type (void);
#define VALA_CCODE_TYPE_DEFINITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_TYPE_DEFINITION, ValaCCodeTypeDefinitionPrivate))
enum  {
	VALA_CCODE_TYPE_DEFINITION_DUMMY_PROPERTY
};
void vala_ccode_type_definition_set_type_name (ValaCCodeTypeDefinition* self, const char* value);
void vala_ccode_type_definition_set_declarator (ValaCCodeTypeDefinition* self, ValaCCodeDeclarator* value);
ValaCCodeTypeDefinition* vala_ccode_type_definition_new (const char* type, ValaCCodeDeclarator* decl);
ValaCCodeTypeDefinition* vala_ccode_type_definition_construct (GType object_type, const char* type, ValaCCodeDeclarator* decl);
ValaCCodeTypeDefinition* vala_ccode_type_definition_new (const char* type, ValaCCodeDeclarator* decl);
static void vala_ccode_type_definition_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
GType vala_ccode_line_directive_get_type (void);
void vala_ccode_writer_write_indent (ValaCCodeWriter* self, ValaCCodeLineDirective* line);
void vala_ccode_writer_write_string (ValaCCodeWriter* self, const char* s);
const char* vala_ccode_type_definition_get_type_name (ValaCCodeTypeDefinition* self);
ValaCCodeDeclarator* vala_ccode_type_definition_get_declarator (ValaCCodeTypeDefinition* self);
void vala_ccode_node_write_declaration (ValaCCodeNode* self, ValaCCodeWriter* writer);
void vala_ccode_writer_write_newline (ValaCCodeWriter* self);
static void vala_ccode_type_definition_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_type_definition_parent_class = NULL;
static void vala_ccode_type_definition_finalize (ValaCCodeNode* obj);



ValaCCodeTypeDefinition* vala_ccode_type_definition_construct (GType object_type, const char* type, ValaCCodeDeclarator* decl) {
	ValaCCodeTypeDefinition* self;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (decl != NULL, NULL);
	self = (ValaCCodeTypeDefinition*) g_type_create_instance (object_type);
	vala_ccode_type_definition_set_type_name (self, type);
	vala_ccode_type_definition_set_declarator (self, decl);
	return self;
}


ValaCCodeTypeDefinition* vala_ccode_type_definition_new (const char* type, ValaCCodeDeclarator* decl) {
	return vala_ccode_type_definition_construct (VALA_TYPE_CCODE_TYPE_DEFINITION, type, decl);
}


static void vala_ccode_type_definition_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeTypeDefinition * self;
	self = (ValaCCodeTypeDefinition*) base;
	g_return_if_fail (writer != NULL);
}


static void vala_ccode_type_definition_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeTypeDefinition * self;
	self = (ValaCCodeTypeDefinition*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "typedef ");
	vala_ccode_writer_write_string (writer, self->priv->_type_name);
	vala_ccode_writer_write_string (writer, " ");
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self->priv->_declarator, writer);
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_type_definition_get_type_name (ValaCCodeTypeDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_type_name;
}


void vala_ccode_type_definition_set_type_name (ValaCCodeTypeDefinition* self, const char* value) {
	char* _tmp2_;
	const char* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_type_name = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_)), self->priv->_type_name = (g_free (self->priv->_type_name), NULL), _tmp2_);
}


ValaCCodeDeclarator* vala_ccode_type_definition_get_declarator (ValaCCodeTypeDefinition* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_declarator;
}


void vala_ccode_type_definition_set_declarator (ValaCCodeTypeDefinition* self, ValaCCodeDeclarator* value) {
	ValaCCodeDeclarator* _tmp2_;
	ValaCCodeDeclarator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->priv->_declarator = (_tmp2_ = (_tmp1_ = value, (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_)), (self->priv->_declarator == NULL) ? NULL : (self->priv->_declarator = (vala_ccode_node_unref (self->priv->_declarator), NULL)), _tmp2_);
}


static void vala_ccode_type_definition_class_init (ValaCCodeTypeDefinitionClass * klass) {
	vala_ccode_type_definition_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_type_definition_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeTypeDefinitionPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_type_definition_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_type_definition_real_write_declaration;
}


static void vala_ccode_type_definition_instance_init (ValaCCodeTypeDefinition * self) {
	self->priv = VALA_CCODE_TYPE_DEFINITION_GET_PRIVATE (self);
}


static void vala_ccode_type_definition_finalize (ValaCCodeNode* obj) {
	ValaCCodeTypeDefinition * self;
	self = VALA_CCODE_TYPE_DEFINITION (obj);
	self->priv->_type_name = (g_free (self->priv->_type_name), NULL);
	(self->priv->_declarator == NULL) ? NULL : (self->priv->_declarator = (vala_ccode_node_unref (self->priv->_declarator), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_type_definition_parent_class)->finalize (obj);
}


GType vala_ccode_type_definition_get_type (void) {
	static GType vala_ccode_type_definition_type_id = 0;
	if (vala_ccode_type_definition_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeTypeDefinitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_type_definition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeTypeDefinition), 0, (GInstanceInitFunc) vala_ccode_type_definition_instance_init, NULL };
		vala_ccode_type_definition_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeTypeDefinition", &g_define_type_info, 0);
	}
	return vala_ccode_type_definition_type_id;
}




