#!/usr/bin/python

import re
import gtk
import gobject



class Record(gobject.GObject):
    #
    # A record represents a single database entry
    #
    def __init__(self):
        gobject.GObject.__init__(self)

    def setValues(self, name, user, password, category, info):
        self.name=name
        self.user=user
        self.password=password
        self.category=category
        self.info=info

    def toString(self):
        result=''
        cr="\n"
        result+='n: '+self.name+cr
        result+='u: '+self.user+cr
        result+='p: '+self.password+cr
        result+='c: '+self.category+cr
        for line in self.info.split("\n"):
            result+="i: "+line+cr
        result+=cr
        return result

    def toTuple(self):
        return (self,self.name)
    

class DataStore(gtk.ListStore):

    #
    # This class contains both the entire database (in the records
    # array) and the currently visible main window entries (in the
    # inherited ListStore).
    #

    def __init__(self):
        # each model entry consists of the record and the record name
        gtk.ListStore.__init__(self,Record,str)
        self.set_sort_column_id(1,gtk.SORT_ASCENDING)
        self.clearRecords()


    def clearRecords(self):
        # nuke both the record list and the display model
        self.clear()
        self.records=[]

    def deleteRecord(self, iter):
        record=self[iter][0]
        # remove the entry from the list model ...
        self.remove(iter)
        # ... and remove it from the data store
        # Note: this can throw an exception if record is not part of
        # the records list, but I guess that can't happen
        self.records.remove(record)


    def addRecord(self, name, user, password, category, info):
        record=Record()
        record.setValues(name, user, password, category, info)
        self.records.append(record)
        return record
        
    def getCategories(self):
        # return a list of all the sorted, unique category strings
        result=[]
        result.append('')
        for record in self.records:
            cat=record.category
            if result.count(cat)==0:
                result.append(cat)
        result.sort()
        return result

    def dump(self):
        for tuple in self:
            print "%s %s" % (tuple[0], tuple[1])

    def toString(self):
        # Create a string of the databse for saving to disk
        result=''
        for record in self.records:
            result+=record.toString()
        return result

    def fromString(self, s):
        # initialize the database, e.g. from the decrypted file
        name=None
        user=''
        password=''
        category=''
        info=''
        lineNo=0
        self.clearRecords()
        for line in s.split("\n"):
            #print "line='"+line+"'"
            lineNo+=1
            # skip blank lines and comments
            if not re.match("\s*(#.*|\s*)$", line):
                match=re.match("([nupci]):\s*(.*)", line)
                if match:
                    key=match.group(1)
                    val=match.group(2)
                    if key=='n':
                        if name!=None:
                            self.addRecord(name, user, password, category, info)
                            user=''
                            password=''
                            category=''
                            info=''
                        name=val
                    else:
                        if key=='u':
                            user=val
                        elif key=='p':
                            password=val
                        elif key=='c':
                            category=val
                        elif key=='i':
                            if info!='':
                                info+="\n"+val
                            else:
                                info=val
                        else:
                            raise ValueError("Line "+str(lineNo)+": unknown field code "+key)
                else:
                    raise ValueError("Line "+str(lineNo)+": can't parse "+line)
        if name!=None:
            self.addRecord(name, user, password, category, info)



    def filter(self, search, category):
        # Initialize the list model base on the list of records, a
        # search string, and the category to filter for
        self.clear()
        result=0
        for record in self.records:
            if (category=='' or record.category==category) and (search=='' or record.name.find(search)>=0):
                tuple=record.toTuple()
                self.append(tuple)
                result+=1
            else:
                record.iter=None
                #print "skip"
        return result
            


if __name__=="__main__":
    # dummy main code, not used
    store=DataStore()
    store.append(['My Bank', 'johndoe', 'secret', 'money', "foo\nbar"])
    store.append(['Google', 'xyz123', 'secret', 'internet', "Since 12/23/2009"])
    store.append(['Yahoo', 'xyz123', 'secret', 'internet', ''])
    store.append(['MSN', 'xyz123', 'secret', 'internet', ''])
    store.append(['AOL', 'xyz123', 'secret', 'internet', "Not really using this\naccount any more"])
    #store.dump()

    masterPassword='hokuspokus'
    ob=Blowfish.new(masterPassword)
    s=store.toString()

    encrypted=ob.encrypt(s)
    s=ob.decrypt(encrypted)
    print s

    store.fromString(s)
    store.dump()
