#
# This is the database property module for SplitTheTab.
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

import pygtk
pygtk.require('2.0')
import gtk
from DataStore import Record

try:
    import hildon
    isHildon=True
except ImportError:
    isHildon=False



class Editor(gtk.Dialog):


    def makeEntry(self, row, text, model=None):
        label=gtk.Label(text)
        label.set_alignment(0,0)
        self.grid.attach(label, 0, 1, row, row+1, gtk.FILL, gtk.FILL)

        if model:
            widget=gtk.ComboBoxEntry(model, 0)
            entry=widget.child
        else:
            widget=gtk.Entry()
            entry=widget
        self.grid.attach(widget, 1, 2, row, row+1, gtk.FILL|gtk.EXPAND, gtk.FILL)
        return entry

    def makeText(self, row, text):
        #label=gtk.Label(text)
        #label.set_alignment(0,0)
        #grid.attach(label, 0, 1, row, row+1, gtk.FILL, gtk.FILL)

        text=gtk.TextView()
        text.set_size_request(0, 100)
        self.grid.attach(text, 0, 2, row, row+1, gtk.FILL|gtk.EXPAND, gtk.FILL|gtk.EXPAND)
        return text

    def getRecord(self):
        buffer=self.infoText.get_buffer()
        result=Record(-1,
                     self.nameEntry.get_text(),
                     self.userEntry.get_text(),
                     self.passwordEntry.get_text(),
                     self.categoryEntry.get_text(),
                     buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter()))
        return result


    def __init__(self, parent, pwEntry, categories):
        gtk.Dialog.__init__(self,
                            title='Edit Entry',
                            parent=parent,
                            flags=gtk.DIALOG_DESTROY_WITH_PARENT,
                            buttons=(gtk.STOCK_APPLY, gtk.RESPONSE_ACCEPT,
                                     gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))

        self.grid=gtk.Table(rows=5, columns=2)
        self.vbox.pack_start(self.grid, fill=True)
        self.nameEntry=self.makeEntry(0, 'Name')
        self.userEntry=self.makeEntry(1, 'User')
        self.passwordEntry=self.makeEntry(2, 'Password')

        model=gtk.ListStore(str)
        for cat in categories:
            model.append((cat,))
        self.categoryEntry=self.makeEntry(3, 'Category', model)
        self.infoText=self.makeText(4, 'Info')


        self.nameEntry.set_text(pwEntry.name)
        self.userEntry.set_text(pwEntry.user)
        self.passwordEntry.set_text(pwEntry.password)

        
        self.categoryEntry.set_text(pwEntry.category)
        self.infoText.get_buffer().set_text(pwEntry.info)

        self.show_all()

