#!/usr/bin/python2.5

from optparse import OptionParser
import TrustMe.Main

version=TrustMe.Main.version
parser=OptionParser(usage="usage: %prog [options]",
                    version="%prog "+version)
parser.add_option("-d", "--dump",
                  help="de-crypt the vault and dump it to standard output",
                  )
parser.add_option("-r", "--restore",
                  help="encrypte standard input and dump it to standard output",
                  default=False
                  )
(options, args)=parser.parse_args()


if options.restore and options.dump:
    parser.error("Can't both restore and dump at the same time")


if options.restore or options.dump:

    if len(args)!=1:
        parser.error("Missing output file")
    outputFn=args[0]
    
    import getpass
    from TrustMe.Vault import Vault
    password=getpass.getpass('Encryption password:')
    vault=TrustMe.Vault.Vault()
    vault.setPassword(password)

    if options.dump:
        tuple=vault.load(options.dump, "#TrustMe (\d+)$")
        schemaVersion=tuple[0]
        content=tuple[1]
        
        if schemaVersion!="1":
            raise Vault.EncryptedFileError("Unsupported schema version '"+str(schemaVersion)+"'")
        fp=open(outputFn, 'w')
        fp.write(content)
        fp.close()
    else:
        fp=open(options.restore, 'r')
        content=fp.read()
        fp.close()
        header="#TrustMe 1"
        vault.save(outputFn, header,content)

        
else:
    # default mode - launch the GUI
    app=TrustMe.Main.Main()
    app.createGui()
    app.run()
