#!/usr/local/bin/python
# -*- coding: utf-8 -*-

import unittest
import blowfish

''' copy-pasted from __init__.py
'''
# if True: a dummy encrypted data is used
DUMMY_SAFE_IMPLEMENTATION = False
DUMMY_PATERN = 'X'

class Blowfish(blowfish.Blowfish):
    ''' Implementation of the Crypto.Cipher.Blowfish API
        using a pure-python blowfish module.
    '''
    avoid_recursive = True
    
    @staticmethod
    def new(key):
        inst = Blowfish(key)
        inst.avoid_recursive = False
        return inst
    
    def encrypt(self, data):
        if DUMMY_SAFE_IMPLEMENTATION: return DUMMY_PATERN * len(data)
        if self.avoid_recursive:
            return blowfish.Blowfish.encrypt(self, data)
        self.avoid_recursive = True
        self.initCTR()
        encrypted = blowfish.Blowfish.encryptCTR(self, data)
        self.avoid_recursive = False
        return encrypted
    
    def decrypt(self, data):
        if DUMMY_SAFE_IMPLEMENTATION: return data
        if self.avoid_recursive:
            return blowfish.Blowfish.decrypt(self, data)
        self.avoid_recursive = True
        self.initCTR()
        decrypted = blowfish.Blowfish.decryptCTR(self, data)
        self.avoid_recursive = False
        return decrypted


class TestBlowfish(unittest.TestCase):
    def setUp(self):
        DUMMY_SAFE_IMPLEMENTATION = False
        
    def test_basic(self):
        key = 'This is a test key'
        cipher = Blowfish.new(key)
        text = "The quick brown fox jumps over the lazy dog"
        print "\n\tText:\t\t", text
        crypted = cipher.encrypt(text)
        print "\tEncrypted:\t", crypted
        decrypted = cipher.decrypt(crypted)
        print "\tDecrypted:\t", decrypted
        self.assertEquals(text, decrypted, "decrypted text ok.")
    
    def test_dummy(self):
        global DUMMY_SAFE_IMPLEMENTATION
        DUMMY_SAFE_IMPLEMENTATION = True
        key = 'This is a test key'
        cipher = Blowfish.new(key)
        text = "The quick brown fox jumps over the lazy dog"
        print "\n\tText:\t\t", text
        crypted = cipher.encrypt(text)
        self.assertEquals(crypted, DUMMY_PATERN * len(text))
        print "\tEncrypted:\t", crypted
        decrypted = cipher.decrypt(crypted)
        print "\tDecrypted:\t", decrypted
        self.assertNotEquals(text, decrypted, "decrypted text is different.")
        self.assertEquals(DUMMY_PATERN * len(text), decrypted, "dummy data.")


if __name__ == '__main__':
    unittest.main()
