/*
-------------------------------------------------------------------
SUDOKU SENSEI 1.03: a Sudoku Explainer Engine
Copyright (C) 2005  Martin Knoblauch

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA  02110-1301, USA.

Contact the author: comocomocomo AT users.sourceforge.net
Latest versions: http://sourceforge.net/projects/sudoku-sensei
-------------------------------------------------------------------

    list.h    Doubly linked lists

              Note that the nodes do not contain anything
              but the list links. The payload is not "inside"
              the nodes of the list. It is indeed the other
              way around. This kind of generic list performs
              as good as concrete lists, since no additional
              indirection level is required.

              The elements of the list, defined externally,
              must contain their payload, and a field of
              type t_lnode.

              The macro GET_ELEM receives the address of
              this field and returns the address of the
              element that contains it.

              The elements can be simultaneously in more than
              one list by having more than one t_lnode
              fields.
*/

#ifndef _LINKED_LIST_H_
#define _LINKED_LIST_H_


typedef struct s_lnode
{
  struct s_lnode * next;
  struct s_lnode * prev;
}
t_lnode;

typedef struct s_list
{
  t_lnode * first;
  t_lnode * last;
  int num;
}
t_list;


#define GET_ELEM(TYPE,NODE,FIELD)                    \
                 ((TYPE*)((int)(NODE) -              \
                          (int)&((TYPE*)0)->FIELD))


#ifdef INLINE
#undef INLINE
#endif
#define INLINE


INLINE t_lnode * ListGetFirst (t_list * ls);
INLINE t_lnode * ListGetLast (t_list * ls);
INLINE int ListGetNum (t_list * ls);
INLINE t_lnode * ListGetNext (t_lnode * n);
INLINE t_lnode * ListGetPrev (t_lnode * n);
INLINE void ListReset (t_list * ls);
INLINE void ListInsert (t_list * ls, t_lnode * n);
INLINE void ListAppend (t_list * ls, t_lnode * n);
INLINE void ListExtract (t_list * ls, t_lnode * n);


#endif
