/*
-------------------------------------------------------------------
SUDOKU SENSEI 1.03: a Sudoku Explainer Engine
Copyright (C) 2005  Martin Knoblauch

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA  02110-1301, USA.

Contact the author: comocomocomo AT users.sourceforge.net
Latest versions: http://sourceforge.net/projects/sudoku-sensei
-------------------------------------------------------------------

    list.c    Doubly linked lists

              (See general explanation in list.h)
*/

#include "list.h"

#ifndef NULL
#define NULL 0
#endif

INLINE t_lnode * ListGetFirst (t_list * ls)
{
  return ls->first;
}

INLINE t_lnode * ListGetLast (t_list * ls)
{
  return ls->last;
}

INLINE int ListGetNum (t_list * ls)
{
  return ls->num;
}

INLINE t_lnode * ListGetNext (t_lnode * n)
{
  return n->next;
}

INLINE t_lnode * ListGetPrev (t_lnode * n)
{
  return n->prev;
}

INLINE void ListReset (t_list * ls)
{
  ls->first = NULL;
  ls->last = NULL;
  ls->num = 0;
}

INLINE void ListInsert (t_list * ls, t_lnode * n)
{
  n->prev = NULL;

  if ((n->next = ls->first))
    n->next->prev = n;
  else
    ls->last = n;

  ls->first = n;
  ls->num ++;
}

INLINE void ListAppend (t_list * ls, t_lnode * n)
{
  n->next = NULL;

  if ((n->prev = ls->last))
    n->prev->next = n;
  else
    ls->first = n;

  ls->last = n;
  ls->num ++;
}

INLINE void ListExtract (t_list * ls, t_lnode * n)
{
  if (n->next)
    n->next->prev = n->prev;
  else
    ls->last = n->prev;

  if (n->prev)
    n->prev->next = n->next;
  else
    ls->first = n->next;

  ls->num --;
}
