/*
 * Tomiku
 *
 * Project homepage: http://tomiku.garage.maemo.org
 * Author homepage: http://www.aivokyyti.net
 *
 * Copyright (C) 2007 Tomi Pihlainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA. 
 *
 */

#include <stdlib.h>
#include <time.h>

#include "game.h"

#define _(String) gettext(String)

#include <config.h>

/* Game state */
int game_state;

/* Game duration */
time_t game_duration;

/* Last time when game was started (either new game or started again
   after pause */
time_t game_start_time;

int get_game_state()
{
    return game_state;
}

int start_new_game()
{
    game_state = GAME_STATE_PLAY;
    game_duration = 0;
    game_start_time = time(NULL);
    return 0;
}

int pause_game()
{
    if (game_state != GAME_STATE_PLAY)
        return -1;
        
    game_state = GAME_STATE_PAUSED;
    game_duration = game_duration + time(NULL) - game_start_time;
    return 0;
}

int continue_game()
{
    if (game_state != GAME_STATE_PAUSED)
        return -1;
        
    game_state = GAME_STATE_PLAY;
    game_start_time = time(NULL);
    return 0;
}

int end_game()
{
    if (game_state != GAME_STATE_ENDED)
    {
        game_state = GAME_STATE_ENDED;
        game_duration = game_duration + time(NULL) - game_start_time;
    }
    return 0;
}

time_t get_game_duration()
{
    if (game_state == GAME_STATE_PLAY)
        return game_duration + time(NULL) - game_start_time;
    else
        return game_duration;
}
