function [r] = createlinestr(ind, data)
	for i = 1:length(ind)
		r(1, i) = ind(i);
		r(2, i) = data(ind(i));
	end
endfunction

function [r] = linestr(ls, x, fr)
	T = 1/fr;
	d = T / ls(1, size(ls, 2));

	curxi = 1;

	while curxi <= length(x)
		for i = 1:size(ls, 2) - 1
			segLenX = (ls(1, i + 1) - ls(1, i)) * d;
			segDelta = ls(2, i + 1) - ls(2, i);
			k = segDelta/segLenX;
			
			b = - k * ls(1, i) * d + ls(2, i);
			
			periodsCalced = int(x(curxi) / T);
			while x(curxi) < (ls(1, i + 1) * d) + periodsCalced * T
				r(curxi) = k * modulo(x(curxi), T) + b;
				curxi = curxi + 1;
				if curxi > length(x)
					break;
				end
			end
			if curxi > length(x)
				break;
			end
		end
	end
endfunction


//w = loadwave("violin2.wav");
//fr = 1/length(w);

//ind = [1 20 55 65 80 113 121 126 138 149 160 165 181 190 203 215 220 length(w)];

//ls = createlinestr(ind, w);

//x = 1:length(w);
//y = linestr(ls, x, fr);

//y = y / max(abs(y));

//plot(x, y, 'b');
//plot(x, w, 'r');

//xlong = 1:10000;
//ylong = linestr(ls, xlong, fr);

//ylong = ylong / max(abs(ylong));
////plot(xlong, ylong, 'r');

//sound(ylong', 44100);




w = loadwave("fiddle.wav");
fr = 1 / length(w);

ind = [1 4 8 10 13 17 28 34 40 51 56 64 77 90 97 105 109 112 124 134 140 143 146 149 length(w)];

ls = createlinestr(ind, w);


x = 1:length(w);
y = linestr(ls, x, fr);

y = y / max(abs(y));

//plot(x, y, 'b');
//plot(x, w, 'r');

//xlong = 1:10000;
//ylong = linestr(ls, xlong, fr);

////ylong = ylong / max(abs(ylong));
////plot(xlong, ylong, 'r');

//sound(ylong', 44100);





//Piano excitation force

ls = [1  13  17  20  23  39  42  45  54  57  60  80  83  86  92  95  98 120 130 150 200;
      0  85  98 100  98  58  55  58  73  75  73  35  33  35  44  45  44  21  14   5   0];

x = 1:ls(1, size(ls, 2));
y = linestr(ls, x, 1 / length(x));

plot(x, y, 'b');




//Piano excitation pulse

ls = [1,  5, 10, 15, 17,  20,  23,  25, 28,     32,  35,  37,   40,  43,  44,  46,    54, 56, 57,  60,  63, 64, 66,      74,  77,  80,  83,  86,     94, 97, 100, 103, 106,    114, 117, 120, 123, 130, 140, 160, 200;
      0, 38, 70, 93, 98, 100,  98,  93, 63,    -63, -93, -98, -100, -98, -95, -80,    55, 69, 73,  75,  73, 69, 55,     -63, -73, -75, -73, -60,     32, 43,  45,  42,  32,    -13, -19, -21, -19, -13,  -8   -3,   0];

x = 1:ls(1, size(ls, 2));
y = linestr(ls, x, 1 / length(x));

plot(x, y, 'g');



/*
function [r] = highpass(x, fr)
	rc = 1 / (2 * 3.14159 * fr);
	a = rc / (rc + 1);

	yo = 0;
	xo = 0;

	for i = 1:length(y)
		yo = a * yo + a * (x(i) - xo);
		xo = x(i);
		r(i) = yo;
	end
endfunction


yf = highpass(y, 400 / 44100);

plot(x, yf, 'r');
*/

