function [r] = createlinestr(ind, data)
	for i = 1:length(ind)
		r(1, i) = ind(i);
		r(2, i) = data(ind(i));
	end
endfunction

function [r] = linestr(ls, x, fr)
	T = 1/fr;
	d = T / ls(1, size(ls, 2));

	curxi = 1;

	while curxi <= length(x)
		for i = 1:size(ls, 2) - 1
			segLenX = (ls(1, i + 1) - ls(1, i)) * d;
			segDelta = ls(2, i + 1) - ls(2, i);
			k = segDelta/segLenX;
			
			b = - k * ls(1, i) * d + ls(2, i);
			
			periodsCalced = int(x(curxi) / T);
			while x(curxi) < (ls(1, i + 1) * d) + periodsCalced * T
				r(curxi) = k * modulo(x(curxi), T) + b;
				curxi = curxi + 1;
				if curxi > length(x)
					break;
				end
			end
			if curxi > length(x)
				break;
			end
		end
	end
endfunction


//w = loadwave("violin2.wav");
//fr = 1/length(w);

//ind = [1 20 55 65 80 113 121 126 138 149 160 165 181 190 203 215 220 length(w)];

//ls = createlinestr(ind, w);

//x = 1:length(w);
//y = linestr(ls, x, fr);

//y = y / max(abs(y));

//plot(x, y, 'b');
//plot(x, w, 'r');

//xlong = 1:10000;
//ylong = linestr(ls, xlong, fr);

//ylong = ylong / max(abs(ylong));
////plot(xlong, ylong, 'r');

//sound(ylong', 44100);




w = loadwave("fiddle.wav");
fr = 1 / length(w);

ind = [1 4 8 10 13 17 28 34 40 51 56 64 77 90 97 105 109 112 124 134 140 143 146 149 length(w)];

ls = createlinestr(ind, w);


x = 1:length(w);
y = linestr(ls, x, fr);

y = y / max(abs(y));

plot(x, y, 'b');
plot(x, w, 'r');

xlong = 1:10000;
ylong = linestr(ls, xlong, fr);

//ylong = ylong / max(abs(ylong));
//plot(xlong, ylong, 'r');

sound(ylong', 44100);
