/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/* 
 * File:   MainWindow.hpp
 * Author: ivan
 *
 * Created on February 23, 2009, 1:17 AM
 */

#pragma once


#include <gtkmm/menu.h>
#include <gtkmm/drawingarea.h>

#include <ting/types.hpp>
#include <ting/Fixed.hpp>
#include <aumiks/synth/synth.hpp>

#include "utils.hpp"
#include "Preferences.hpp"



class ThereminView : public Gtk::DrawingArea{
#ifdef M_USE_FIXED_POINT
	typedef ting::Fixed<16> real;
#else
	typedef float real;
#endif

	MonotonicInstrumentHolder instr;

	ting::uint curOctave;//for locking to first tapped octave

	float tappedX;
public:
	ThereminView();
	~ThereminView(){
//		TRACE(<< "~ThereminView(): invoked" << std::endl)
	}

	void OnShow();

	bool OnButtonPressEvent(GdkEventButton* event);
	bool OnButtonReleaseEvent(GdkEventButton* event);
	bool OnMotionEvent(GdkEventMotion* event);
	bool OnKeyPress(GdkEventKey* event);
	void OnKeyPress_Notify(GdkEventKey* event);

	bool OnExposeEvent(GdkEventExpose* event);

	void ShowOptionsDialog();

	inline ting::uint PitchRange()const{
		return Preferences::Inst().GetNumOctaves() * 12;
	};

	struct FreqVol{
		real freq;
		ting::u8 vol;
	};

	//if isPressEvent is true then this->curOctave will be updated,
	//otherwise the old value will be used
	FreqVol CalcFreqAndVol(real scrW, real scrH, real tapX, real tapY, bool isPressEvent);

	static ting::u8 CalcVol(real y, real height);

	static void DrawOctave(Cairo::RefPtr<Cairo::Context> c, ting::uint w, ting::uint h, ting::uint basePitch);
};


