/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include <gtkmm/dialog.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm-2.4/gtkmm/container.h>
#include <gtkmm-2.4/gtkmm/radiobutton.h>
#include <gtkmm-2.4/gtkmm/togglebutton.h>

#include "stdafx.hpp"
#include "OptionsDialog.hpp"



OptionsDialog::OptionsDialog(Gtk::Window &parent) :
		Gtk::Dialog("Options", parent, true),
		octavesFrame("Number of octaves"),
		oneOctaveRadioButton("One octave"),
		twoOctavesRadioButton("Two octaves"),
		threeOctavesRadioButton("Three octaves"),
		timbreFrame("Timbre"),
		sinePlusADSRRadioButton("Sine + ADSR"),
		pluckedStringRadioButton("Plucked string"),
		lockCurrentOctaveCheckbox("Lock to tapped octave")
{
	this->get_vbox()->add(this->hBox);
	this->hBox.add(this->octavesFrame);
	this->octavesFrame.add(this->octavesBox);

	{//group octaves radio buttons
		Gtk::RadioButtonGroup gr = this->oneOctaveRadioButton.get_group();
		this->twoOctavesRadioButton.set_group(gr);
		this->threeOctavesRadioButton.set_group(gr);
	}
	this->octavesBox.add(this->oneOctaveRadioButton);
	this->oneOctaveRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
	this->octavesBox.add(this->twoOctavesRadioButton);
	this->twoOctavesRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
	this->octavesBox.add(this->threeOctavesRadioButton);
	this->threeOctavesRadioButton.set_size_request(-1, DFingerFriendlyMinSize());


	this->hBox.add(this->timbreFrame);
	this->timbreFrame.add(this->timbreBox);

	{//group timbre radio buttons
		Gtk::RadioButtonGroup gr = this->sinePlusADSRRadioButton.get_group();
		this->pluckedStringRadioButton.set_group(gr);
	}
	this->timbreBox.add(this->sinePlusADSRRadioButton);
	this->sinePlusADSRRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
	this->timbreBox.add(this->pluckedStringRadioButton);
	this->pluckedStringRadioButton.set_size_request(-1, DFingerFriendlyMinSize());

	this->lockCurrentOctaveCheckbox.set_size_request(-1, DFingerFriendlyMinSize());
	this->get_vbox()->add(this->lockCurrentOctaveCheckbox);

	this->add_button("Ok", Gtk::RESPONSE_OK);
	this->add_button("Cancel", Gtk::RESPONSE_CANCEL);

	this->show_all_children();//Show all window child widgets
}



ting::uint OptionsDialog::GetNumOctaves()const{
	if(this->oneOctaveRadioButton.get_active())
		return 1;
	else if(this->twoOctavesRadioButton.get_active())
		return 2;
	else if(this->threeOctavesRadioButton.get_active())
		return 3;
	else
		return 0;
}



void OptionsDialog::SetNumOctaves(ting::uint num){
	switch(num){
		case 1:
			this->oneOctaveRadioButton.set_active(true);
			break;
		case 2:
			this->twoOctavesRadioButton.set_active(true);
			break;
		case 3:
			this->threeOctavesRadioButton.set_active(true);
		default:
			break;
	}
}



Preferences::E_Timbre OptionsDialog::GetTimbre()const{
	if(this->sinePlusADSRRadioButton.get_active())
		return Preferences::SINE_PLUS_ADSR;
	else if(this->pluckedStringRadioButton.get_active())
		return Preferences::PLUCKED_STRING;
	else
		return Preferences::UNKNOWN;
}



void OptionsDialog::SetTimbre(Preferences::E_Timbre timbre){
	switch(timbre){
		case Preferences::SINE_PLUS_ADSR:
			this->sinePlusADSRRadioButton.set_active(true);
			break;
		case Preferences::PLUCKED_STRING:
			this->pluckedStringRadioButton.set_active(true);
			break;
		default:
			break;
	}
}



bool OptionsDialog::GetLockToTappedOctave()const{
	return this->lockCurrentOctaveCheckbox.get_active();
}



void OptionsDialog::SetLockToTappedOctave(bool lockToOctave){
	this->lockCurrentOctaveCheckbox.set_active(lockToOctave);
}
