// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//	Database thread


#include <string>

#include "DatabaseThread.hpp"
#include "Therver.hpp"


using namespace ting;



const char* DDatabaseFilename = "users.db";
const char* DUsersTableName = "users";
const char* DUsernameColumn = "un";
const char* DPasswordColumn = "pw";



DatabaseThread::DatabaseThread(Therver *mt, const std::string& dataDir) :
		t(mt),
		db(dataDir + DDatabaseFilename)
{
	ASSERT(this->t)

	//create users table if it does not exist
	try{
		this->db.CreateTable(
				DUsersTableName,
				std::string(DUsernameColumn) + " TEXT, " + DPasswordColumn + " TEXT"
			);
	}catch(sqlite::SQLExc& e){
		//ignore, table may already exist
	}
}



void DatabaseThread::Run(){
	while(!this->quitFlag){
		this->queue.GetMsg()->Handle();
	}
}



//override
void QueryUserPasswordMessage::Handle(){
	ASSERT(this->t)
	ASSERT(this->un.size() > 0)

	sqlite::Cursor cursor = this->t->db.Query(
			DUsersTableName,
			std::string(DUsernameColumn) + ", " + DPasswordColumn, //what
			std::string(DUsernameColumn) + " = '" + this->un + "'" //where
		);

	if(!cursor.MoveToNext()){
		//send USERNAME_NOT_FOUND reply
		this->t->t->PushMessage(Ptr<Message>(
				new UserPasswordQueriedMessage(
						this->t->t,
						this->c,
						std::string(),
						UserPasswordQueriedMessage::USERNAME_NOT_FOUND
					)
			));
		return;
	}

	std::string pw = cursor.GetText(DPasswordColumn);

	ASSERT(!cursor.MoveToNext())

	//send SUCCESS reply to main thread
	this->t->t->PushMessage(Ptr<Message>(
			new UserPasswordQueriedMessage(
					this->t->t,
					this->c,
					pw,
					UserPasswordQueriedMessage::SUCCESS
				)
		));
}



//override
void RegisterNewUserMessage::Handle(){
	ASSERT(this->t)

	//check if such username is already taken
	{
		sqlite::Cursor cursor = this->t->db.Query(
				DUsersTableName,
				std::string(DUsernameColumn), //what
				std::string(DUsernameColumn) + " = '" + this->un + "'" //where
			);

		//if cursor is not empty
		if(cursor.MoveToNext()){
			//send USERNAME_ALREADY_TAKEN message
			this->t->t->PushRegisterResultMessage(
					Therver::REGISTERRES_USERNAME_ALREADY_TAKEN,
					this->c
				);
			return;
		}
	}

	//insert new database entry
	try{
		this->t->db.Insert(
				DUsersTableName,
				std::string(DUsernameColumn) + ", " + DPasswordColumn,
				std::string("'") + this->un + "', '" + this->pw + "'"
			);
	}catch(sqlite::SQLExc& e){
		//send error message
		this->t->t->PushRegisterResultMessage(
				Therver::REGISTERRES_SOME_ERROR,
				this->c
			);
	}

	//send SUCCESS message
	this->t->t->PushRegisterResultMessage(
			Therver::REGISTERRES_SUCCESS,
			this->c
		);
}
