// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//          Music playback thread class

#pragma once

#include <deque>

#include <ting/debug.hpp>
#include <ting/types.hpp>
#include <ting/Array.hpp>
#include <ting/Thread.hpp>

#include <aumiks/synth/synth.hpp>

//==============================================================================
//==============================================================================
//==============================================================================
class PlaybackThread : public ting::Thread{
	friend class PushMusicDataMessage;
	friend class PlayerSwitchMessage;

	
	ting::Ref<aumiks::Instrument> instr;//current instrument
	ting::Ref<aumiks::Instrument::Channel> ch;

	std::deque<ting::Array<ting::byte> > musicDataQueue;

	bool playerHasSwitched;

	enum EMusicAction{
		NOTE_ON = 0,
		NOTE_OFF = 1
	};
public:
	PlaybackThread();
	~PlaybackThread(){};

	//override
	void Run();


	void PushNewPlaybackData_ts(ting::Array<ting::byte> data);

	void HandlePlayerSwitch_ts();
private:

};
//==============================================================================
//==============================================================================
//==============================================================================



class PushMusicDataMessage : public ting::Message{
	PlaybackThread* t;

	ting::Array<ting::byte> data;

public:
	PushMusicDataMessage(
			PlaybackThread* thread,
			ting::Array<ting::byte> musicData
		) :
			t(thread),
			data(musicData)
	{
		ASSERT(this->t)
	}

	//override
	void Handle();
};



class PlayerSwitchMessage : public ting::Message{
	PlaybackThread* t;
public:
	PlayerSwitchMessage(PlaybackThread* thread) :
			t(thread)
	{
		ASSERT(this->t)
	}

	//override
	void Handle(){
		this->t->playerHasSwitched = true;
	}
};


