// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//

#include <ting/debug.hpp>
#include <ting/Array.hpp>
#include <ting/types.hpp>

#include "Client.hpp"


using namespace ting;



void Client::SendLoginResult(bool success){
	Array<byte> p(2);

	p[0] = 0;
	p[1] = success ? 0 : 1;

	this->SendNetworkData_ts(p);
}



void Client::SendPlayingPlayer(const std::string& playerNickname){
	Array<ting::byte> p(1 + 2 + playerNickname.size());

	ting::uint i = 0;
	p[i] = 0x01;
	++i;

	ting::ToNetworkFormat16(playerNickname.size(), &p[i]);
	i += 2;

	memcpy(&p[i], playerNickname.c_str(), playerNickname.size());
	ASSERT(i + playerNickname.size() == p.Size())

	this->SendNetworkData_ts(p);
}



void Client::SendStopListening(){
	Array<byte> p(1);

	p[0] = 0x02;

	this->SendNetworkData_ts(p);
}
