/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/* 
 * File:   MainWindow.hpp
 * Author: ivan
 *
 * Created on February 23, 2009, 1:17 AM
 */

#ifndef M_MainWindow_hpp
#define	M_MainWindow_hpp

#include <hildonmm/window.h>

#include <ting/types.hpp>
#include <aumiks/synth/synth.hpp>

#include "OptionsDialog.hpp"
#include "AboutDialog.hpp"
#include "Preferences.hpp"



class MainWindow : public Hildon::Window{
	ting::Ref<aumiks::Instrument> instr;//current instrument
	ting::Ref<aumiks::Instrument::Channel> ch;

	bool isFullscreen;

	Gtk::Menu mainMenu;
	Gtk::MenuItem optionsMenuItem;
	Gtk::MenuItem saveTuningMenuItem;
	Gtk::SeparatorMenuItem menuSeparator2;
	Gtk::MenuItem exitMenuItem;
	Gtk::SeparatorMenuItem menuSeparator1;
	Gtk::MenuItem aboutMenuItem;

	OptionsDialog optionsDialog;
	AboutDialog aboutDialog;

	Preferences prefs;

	ting::uint curOctave;//for locking to first tapped octave

	float tappedX;
public:
	MainWindow();

	bool OnButtonPressEvent(GdkEventButton* event);
	bool OnButtonReleaseEvent(GdkEventButton* event);
	bool OnMotionEvent(GdkEventMotion* event);
	bool OnKeyPress(GdkEventKey* event);
	void OnKeyPress_Notify(GdkEventKey* event);

	bool OnExposeEvent(GdkEventExpose* event);

	void ShowOptionsDialog();
	void ShowAboutDialog();

	void ApplyTimbre(Preferences::E_Timbre timbre);
	Preferences::E_Timbre GetCurrentTimbreType()const;

	inline ting::uint PitchRange()const{
		return this->prefs.GetNumOctaves() * 12;
	};

	struct FreqVol{
		float freq;
		ting::u8 vol;
	};

	//if isPressEvent is true then this->curOctave will be updated,
	//otherwise the old value will be used
	FreqVol CalcFreqAndVol(float scrW, float scrH, float tapX, float tapY, bool isPressEvent);

	static inline const char* DPreferencesFileName(){
		return "preferences.xml";
	}

	void LoadPreferencesFromFile();
	void SavePreferencesToFile();

	void Exit();

	static float CalcFreq(float baseFreq, float numOctavesToShift);
	static ting::u8 CalcVol(float y, float height);

	static float PitchToFreq(ting::uint pitch);

	static void DrawOctave(Cairo::RefPtr<Cairo::Context> c, ting::uint w, ting::uint h, ting::uint basePitch);
};

#endif	/* _MAINWINDOW_HPP */

