/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include <gtkmm/dialog.h>
#include <gtkmm/radiobutton.h>

#include "stdafx.hpp"
#include "OptionsDialog.hpp"


OptionsDialog::OptionsDialog(Gtk::Window &parent) :
		Gtk::Dialog("Options", parent, true),
		octavesFrame("Number of octaves"),
		oneOctaveRadioButton("One octave"),
		twoOctavesRadioButton("Two octaves"),
		threeOctavesRadioButton("Three octaves")
{
	this->get_vbox()->add(this->octavesFrame);
	this->octavesFrame.add(this->octavesBox);

	{//group octaves radio buttons
		Gtk::RadioButtonGroup gr = this->oneOctaveRadioButton.get_group();
		this->twoOctavesRadioButton.set_group(gr);
		this->threeOctavesRadioButton.set_group(gr);
	}
	this->octavesBox.add(this->oneOctaveRadioButton);
	this->oneOctaveRadioButton.set_size_request(DFingerFriendlyMinSize(), DFingerFriendlyMinSize());
	this->octavesBox.add(this->twoOctavesRadioButton);
	this->twoOctavesRadioButton.set_size_request(DFingerFriendlyMinSize(), DFingerFriendlyMinSize());
	this->octavesBox.add(this->threeOctavesRadioButton);
	this->threeOctavesRadioButton.set_size_request(DFingerFriendlyMinSize(), DFingerFriendlyMinSize());

	this->add_button("Ok", 0);
	this->add_button("Cancel", 1);

	this->show_all_children();//Show all window child widgets
};

ting::uint OptionsDialog::GetNumOctaves()const{
	if(this->oneOctaveRadioButton.get_active())
		return 1;
	else if(this->twoOctavesRadioButton.get_active())
		return 2;
	else if(this->threeOctavesRadioButton.get_active())
		return 3;
	else
		return 0;
};

void OptionsDialog::SetNumOctaves(ting::uint num){
	switch(num){
		case 1:
			this->oneOctaveRadioButton.set_active(true);
			break;
		case 2:
			this->twoOctavesRadioButton.set_active(true);
			break;
		case 3:
			this->threeOctavesRadioButton.set_active(true);
		default:
			break;
	}
};
