#ifndef __TELESCOPE_XEVENTLOOP_H
#define __TELESCOPE_XEVENTLOOP_H

#include <X11/Xlib.h>

#include "LinkedList.h"

class XEventHandler;
class XIdleTask;

class XEventLoop
{
    private:
        static XEventLoop *_instance;

        Display *_dpy;

        bool _breakEventLoop;

        LinkedList<XEventHandler*> _eventHandlers;

        LinkedList<XIdleTask*> _idleTasks;

    public:
        static XEventLoop* instance() { return _instance; }

        XEventLoop(Display *dpy);
        ~XEventLoop();

        void addHandler(XEventHandler *handler);
        void addIdleTask(XIdleTask *idleTask);

        void eventLoop();
};


#endif
