//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: DBus.cpp 154 2010-10-08 09:57:00Z mitrandir $


// FIXME: D-Bus thread will not be stopped at exit
// because of infinite timeout in mainloop

#ifdef DBUS

#include "DBus.h"

#include "TeleWindow.h"
#include "LauncherWindow.h"

DBus * DBus::_instance = 0;

Atom DBus::DBUS_MESSAGE = 0;

DBus::DBus(TeleWindow *teleWindow, LauncherWindow *launcherWindow)
{
    _instance = this;

    _teleWindow = teleWindow;
    _launcherWindow = launcherWindow;
    _running = false;
    _stopped = false;

    DBUS_MESSAGE = XInternAtom(_teleWindow->display(), "TELESCOPE_DBUS_MESSAGE", False);

    dbus_threads_init_default();

    DBusError error;
    dbus_error_init(&error);

    _conn = dbus_bus_get(DBUS_BUS_SESSION, &error);
    if (dbus_error_is_set(&error) || _conn == 0)
    {
        fprintf(stderr, "D-Bus connection error: %s\n", error.message);
        return;
    }

    dbus_bus_request_name(_conn, "org.telescope",
            DBUS_NAME_FLAG_DO_NOT_QUEUE, &error);
    if (dbus_error_is_set(&error))
    {
        fprintf(stderr, "D-Bus bus name error: %s\n", error.message);
        return;
    }


    _telescopeVTable.unregister_function = (DBusObjectPathUnregisterFunction)telescope_unregister;
    _telescopeVTable.message_function = (DBusObjectPathMessageFunction)telescope_message;
    dbus_connection_register_object_path(_conn, "/Telescope",
        &_telescopeVTable, this);


    _launcherVTable.unregister_function = (DBusObjectPathUnregisterFunction)launcher_unregister;
    _launcherVTable.message_function = (DBusObjectPathMessageFunction)launcher_message;
    dbus_connection_register_object_path(_conn, "/Launcher",
        &_launcherVTable, this);
}

DBus::~DBus()
{
    stopMainLoop();

    dbus_connection_unref(_conn);
}

void DBus::startMainLoop()
{
    _running = true;
    _stopped = false;

    pthread_create(&_thread, 0, (void*(*)(void*))&mainLoop, this);
}

void DBus::stopMainLoop()
{
    if (_running && ! _stopped)
    {
        _stopped = true;
        pthread_join(_thread, 0);
        _running = false;
        _stopped = false;
    }
}



void DBus::mainLoop(DBus *self)
{
//    while (! self->_stopped)
//    {
//        dbus_connection_read_write(self->_conn, -1);
//        DBusMessage *msg = dbus_connection_pop_message(self->_conn);
//
//        if (msg == 0)
//        {
//            continue;
//        }
//
//        printf("\nD-Bus event\n");
//        printf("path: %s\n", dbus_message_get_path(msg));
//        printf("interface: %s\n", dbus_message_get_interface(msg));
//
//        dbus_message_unref(msg);
//    }

    while (! self->_stopped)
    {
        dbus_connection_read_write_dispatch(self->_conn, 1000);
    }
}



void DBus::sendDBusMessageToWindow(Display *dpy, Window window, DBus::DBusMessageType msg)
{
    XEvent event;
    event.xclient.type = ClientMessage;
    event.xclient.serial = 0;
    event.xclient.send_event = True;
    event.xclient.message_type = DBUS_MESSAGE;
    event.xclient.window = window;
    event.xclient.format = 32;
    event.xclient.data.l[0] = msg;

    XLockDisplay(dpy);
        XSendEvent(dpy, window, False, 0, &event);
        XFlush(dpy);
    XUnlockDisplay(dpy);
}



void DBus::telescope_unregister(DBusConnection *conn, DBus *self)
{
}

DBusHandlerResult DBus::telescope_message(
    DBusConnection *conn,
    DBusMessage *msg,
    DBus *self
)
{
    if (dbus_message_is_method_call(msg, "org.telescope.Telescope", "Show"))
    {
        DBusMessage *reply = dbus_message_new_method_return(msg);
        dbus_connection_send(conn, reply, 0);
        dbus_message_unref(reply);

        sendDBusMessageToWindow(self->_teleWindow->display(), self->_teleWindow->window(), DBusMessageShow);
    }
    else if (dbus_message_is_method_call(msg, "org.telescope.Telescope", "Hide"))
    {
        DBusMessage *reply = dbus_message_new_method_return(msg);
        dbus_connection_send(conn, reply, 0);
        dbus_message_unref(reply);

        sendDBusMessageToWindow(self->_teleWindow->display(), self->_teleWindow->window(), DBusMessageHide);
    }

    return DBUS_HANDLER_RESULT_HANDLED;
}


void DBus::launcher_unregister(DBusConnection *conn, DBus *self)
{
}

DBusHandlerResult DBus::launcher_message(
    DBusConnection *conn,
    DBusMessage *msg,
    DBus *self
)
{
    if (dbus_message_is_method_call(msg, "org.telescope.Launcher", "Show"))
    {
        DBusMessage *reply = dbus_message_new_method_return(msg);
        dbus_connection_send(conn, reply, 0);
        dbus_message_unref(reply);

        sendDBusMessageToWindow(self->_launcherWindow->display(), self->_launcherWindow->window(), DBusMessageShow);
    }
    else if (dbus_message_is_method_call(msg, "org.telescope.Launcher", "Hide"))
    {
        DBusMessage *reply = dbus_message_new_method_return(msg);
        dbus_connection_send(conn, reply, 0);
        dbus_message_unref(reply);

        sendDBusMessageToWindow(self->_launcherWindow->display(), self->_launcherWindow->window(), DBusMessageHide);
    }
//    else if (dbus_message_is_method_call(msg, "org.telescope.Launcher", "Shutdown"))
//    {
//        DBusMessage *reply = dbus_message_new_method_return(msg);
//        dbus_connection_send(conn, reply, 0);
//        dbus_message_unref(reply);
//
//        XLockDisplay(self->_launcherWindow->display());
//        self->_launcherWindow->quit();
//        XFlush(self->_launcherWindow->display());
//        XUnlockDisplay(self->_launcherWindow->display());
//
//        self->stopMainLoop();
//    }

    return DBUS_HANDLER_RESULT_HANDLED;
}


#endif
