#include "XEventLoop.h"

#include "XEventHandler.h"
#include "XIdleTask.h"


XEventLoop* XEventLoop::_instance = 0;


XEventLoop::XEventLoop(Display *dpy)
{
    XEventLoop::_instance = this;

    _dpy = dpy;

    _breakEventLoop = false;
}

XEventLoop::~XEventLoop()
{
}


void XEventLoop::addHandler(XEventHandler *handler)
{
    _eventHandlers.append(handler);
}


void XEventLoop::addIdleTask(XIdleTask *idleTask)
{
    _idleTasks.append(idleTask);
}


void XEventLoop::eventLoop()
{
    XLockDisplay(_dpy);

    _breakEventLoop = false;
    while (! _breakEventLoop)
    {
        do
        {
            XUnlockDisplay(_dpy);

            XEvent event;
            XNextEvent(_dpy, &event);

            XLockDisplay(_dpy);

            for (LinkedList<XEventHandler*>::Iter i = _eventHandlers.head(); i; ++i)
                (*i)->onEvent(&event);
        } while (XPending(_dpy));

        for (LinkedList<XIdleTask*>::Iter i = _idleTasks.head(); i; ++i)
            (*i)->onIdle();
    }

    XUnlockDisplay(_dpy);
}
