//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: DBus.h 145 2010-08-09 10:07:51Z mitrandir $

// DBus - class for dealing with D-Bus

#ifdef DBUS

#ifndef __TELESCOPE__DBUS_H
#define __TELESCOPE__DBUS_H

#include <dbus/dbus.h>

#include <pthread.h>

class TeleWindow;
class LauncherWindow;

class DBus
{
    private:
        static DBus * _instance;
        TeleWindow *_teleWindow;
        LauncherWindow *_launcherWindow;

        DBusConnection *_conn;

        bool _running;
        bool _stopped;

        pthread_t _thread;

        DBusObjectPathVTable _telescopeVTable;
        DBusObjectPathVTable _launcherVTable;

        static void mainLoop(DBus *self);

        static void telescope_unregister(
            DBusConnection *conn,
            DBus *self
        );
        static DBusHandlerResult telescope_message(
            DBusConnection *conn,
            DBusMessage *msg,
            DBus *self
        );

        static void launcher_unregister(
            DBusConnection *conn,
            DBus *self
        );
        static DBusHandlerResult launcher_message(
            DBusConnection *conn,
            DBusMessage *msg,
            DBus *self
        );

    public:
        DBus(TeleWindow *teleWindow, LauncherWindow *launcherWindow);
        ~DBus();

        void startMainLoop();
        void stopMainLoop();

        static DBus * instance() { return _instance; }
        DBusConnection * getConnection() { return _conn; }
};

#endif

#endif
