//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: Resources.h 137 2010-07-31 20:01:18Z mitrandir $

// Resources - loads and ownes all common resources

// Singleton

#ifndef __TELESCOPE__RESOURCES_H
#define __TELESCOPE__RESOURCES_H

#include <X11/Xlib.h>
#include <X11/extensions/Xrender.h>

class Resources
{
    private:
        static Resources *_instance;

        Display *_dpy;

        Pixmap _headerLeftPix;
        Picture _headerLeftPict;
        Pixmap _headerRightPix;
        Picture _headerRightPict;
        Pixmap _headerMiddlePix;
        Picture _headerMiddlePict;
        Pixmap _headerLeftSelectedPix;
        Picture _headerLeftSelectedPict;
        Pixmap _headerRightSelectedPix;
        Picture _headerRightSelectedPict;
        Pixmap _headerMiddleSelectedPix;
        Picture _headerMiddleSelectedPict;
        Pixmap _brokenPatternPix;
        Picture _brokenPatternPict;

        int _headerHeight;
        int _headerLeftWidth;
        int _headerRightWidth;

        XRenderColor _borderColor;
        XRenderColor _borderActiveColor;

        Pixmap _indicatorPixmap;
        Pixmap _navigatorPixmap;
        Pixmap _textBgPixmap;

        Picture _indicatorPicture;
        Picture _navigatorPicture;
        Picture _textBgPicture;

        int _indicatorWidth;
        int _indicatorHeight;
        int _currentIndicatorWidth;
        int _currentIndicatorHeight;

        int _navigationWidth;
        int _navigationHeight;

        int _textBgWidth;
        int _textBgHeight;


        Pixmap _bgPixmap;

    public:
        Resources(Display *dpy);
        ~Resources();

        static Resources* instance() { return _instance; }

        bool loadARGBImage(
            const char *filename,
            Drawable parent,
            Pixmap *pixmap,
            Picture *picture,
            int *width,
            int *height
        );


        Pixmap headerLeftPix()     { return _headerLeftPix; }
        Picture headerLeftPict()   { return _headerLeftPict; }
        Pixmap headerRightPix()    { return _headerRightPix; }
        Picture headerRightPict()  { return _headerRightPict; }
        Pixmap headerMiddlePix()   { return _headerMiddlePix; }
        Picture headerMiddlePict() { return _headerMiddlePict; }
        Pixmap headerLeftSelectedPix()     { return _headerLeftSelectedPix; }
        Picture headerLeftSelectedPict()   { return _headerLeftSelectedPict; }
        Pixmap headerRightSelectedPix()    { return _headerRightSelectedPix; }
        Picture headerRightSelectedPict()  { return _headerRightSelectedPict; }
        Pixmap headerMiddleSelectedPix()   { return _headerMiddleSelectedPix; }
        Picture headerMiddleSelectedPict() { return _headerMiddleSelectedPict; }
        Pixmap brokenPatternPix()   { return _brokenPatternPix; }
        Picture brokenPatternPict() { return _brokenPatternPict; }

        int headerHeight() { return _headerHeight; }
        int headerLeftWidth() { return _headerLeftWidth; }
        int headerRightWidth() { return _headerRightWidth; }


        const XRenderColor* borderColor() { return &_borderColor; }
        const XRenderColor* borderActiveColor() { return &_borderActiveColor; }


        void drawIndicator(Picture canvas, int x, int y);    
        void drawCurrentIndicator(Picture canvas, int x, int y);

        void drawNextNavigation(Picture canvas, int x, int y);
        void drawPrevNavigation(Picture canvas, int x, int y);
        void drawNextPressedNavigation(Picture canvas, int x, int y);
        void drawPrevPressedNavigation(Picture canvas, int x, int y);

        Pixmap getBackgroundPixmap() { return _bgPixmap; }
        Picture getTextBackgroundPicture() { return _textBgPicture; }

        int getIndicatorWidth() { return _indicatorWidth; }
        int getIndicatorHeight() { return _indicatorHeight; }

        int getCurrentIndicatorWidth() { return _currentIndicatorWidth; }
        int getCurrentIndicatorHeight() { return _currentIndicatorHeight; }

        int getNavigationWidth() { return _navigationWidth; }
        int getNavigationHeight() { return _navigationHeight; }

        int getTextBackgroundWidth() { return _textBgWidth; }
        int getTextBackgroundHeight() { return _textBgHeight; }


        void reloadBackground();

        Pixmap bgPixmap() { return _bgPixmap; }
};


#endif
