//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: Main.cpp 137 2010-07-31 20:01:18Z mitrandir $
#include <libintl.h>
#include <locale.h>

#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "TeleWindow.h"
#include "LauncherWindow.h"
#include "XTools.h"
#include "Settings.h"
#include "Resources.h"
#include "DBus.h"

#include "LauncherWindow.h"
#include "SectionList.h"
#include "MenuReader.h"

#include "XEventLoop.h"

int main(int argc, char *argv[])
{
    // prepare i8n
    setlocale(LC_ALL,"");
    bindtextdomain("maemo-af-desktop","/usr/share/locale");
    textdomain("maemo-af-desktop");

    // read the hildon application menu
    SectionList * list = MenuReader::getInstance()->processMenu();
    if (list == NULL)
    {
      fprintf(stderr, "Cannot read the menu configuration");
      return 1;
    }
    
    XInitThreads();

    Settings *settings = new Settings;

    Display *dpy = XOpenDisplay(0);

    if (! dpy)
    {
        fprintf(stderr, "Cannot open display\n");
        return 1;
    }

    XTools::init(dpy);

    if (! XTools::checkCompositeExtension())
    {
        fprintf(stderr, "XServer doesn't support Composite\n");
        return 1;
    }

    if (! XTools::checkDamageExtension())
    {
        fprintf(stderr, "XServer doesn't support Damage\n");
        return 1;
    }

    if (! XTools::checkXRenderExtension())
    {
        fprintf(stderr, "XServer doesn't support XRender\n");
        return 1;
    }

    XTools::enableCompositeRedirect();

    // init resource
    Resources * resources = new Resources(dpy);

    XEventLoop *eventLoop = new XEventLoop(dpy);

    TeleWindow *teleWindow = new TeleWindow(dpy);
    LauncherWindow *launcherWindow = new LauncherWindow(dpy, list);

    DBus *dbus = new DBus(teleWindow, launcherWindow);
    dbus->startMainLoop();

    eventLoop->eventLoop();

    delete eventLoop;

    delete dbus;

    delete teleWindow;
    delete launcherWindow;
    delete resources;
    delete settings;

    XCloseDisplay(dpy);
}
