//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: TeleWindow.h 102 2010-06-29 13:20:56Z mitrandir $

// TeleWindow - main window of Telescope

#ifndef __TELESCOPE__TELEWINDOW_H
#define __TELESCOPE__TELEWINDOW_H

#include <X11/Xlib.h>
#include <X11/extensions/Xrender.h>
#include <X11/Xft/Xft.h>

#include <Imlib2.h>

#include "LinkedList.h"
#include "Mappings.h"

class Thumbnail;

class TeleWindow
{
    private:
        Display *_dpy;
        Window _rootWindow;
        Window _win;
        Picture _picture;
        Picture _bufferPicture;

        bool _breakEventLoop;

        LinkedList<Thumbnail*> _thumbnails;
        bool _thumbnailsListDirty;

        int _width;
        int _height;
        bool _shown;

        KeyCode _hotKeyCode;
        bool _hotKeyPressed;
        KeyCode _selectKeyCode;

        Pixmap _bgPixmap;
        GC _gc;

        XftFont *_xftFont;
        Pixmap _bufferPix;


        XRenderColor _borderColor;
        XRenderColor _borderActiveColor;



        int _scrollBaseX, _scrollBaseY;
        int _scrollX, _scrollY;
        bool _buttonPressed;
        bool _wasScrolling;
        int _buttonPressX, _buttonPressY;
        bool _repaintOnIdle;


        Thumbnail *_activeThumbnail;


        Mappings _mappings;


        void onHotKeyPress();
        void onHotKeyRelease();


        void onButtonPress(XButtonEvent *event);
        void onButtonRelease(XButtonEvent *event);
        void onButtonMotion(XMotionEvent *event);

        void onIdle();

        void setNewSize(int width, int height);
        void reloadBackground();
        void recreateBufferPixmap();

        void animate(Thumbnail *thumb, bool toSmall);

        void blitThumb(Thumbnail *thumbnail);
        void blitBuffer();

        Thumbnail* findThumbnailByCoords(
            Thumbnail *orig,
            int direction
        );

    public:
        TeleWindow(Display *dpy);
        ~TeleWindow();

        Display* display();
        Window window();
        Picture picture();

        void show();
        void hide();
        bool shown();

        int scrollX()
        { return _scrollX; }
        int scrollY()
        { return _scrollY; }


        void updateThumbnailsList();
        void layoutThumbnails();

        Thumbnail* activeThumbnail() { return _activeThumbnail; }

        void removeThumbnail(Thumbnail *thumb);

        void eventLoop();

        void onRootEvent(XEvent *event);
        void onEvent(XEvent *event);

        void paint();

        void onThumbRedrawed(Thumbnail *thumb);

        void internalCommand(const char *action);

        void markThumbnailsListDirty();

        XftFont* xftFont() { return _xftFont; }

        void showDesktop();
};


#endif
