//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: Settings.h 102 2010-06-29 13:20:56Z mitrandir $

// Settings - loads and provides settings from configuration file

#ifndef __TELESCOPE__SETTINGS_H
#define __TELESCOPE__SETTINGS_H

class Settings
{
    public:
        enum BackgroundMode
        {
            Stretched,
            Centered,
            Scaled,
            Cropped
        };

    private:
        static Settings *_instance;

        bool _scrollingEnabled;
        char *_backgroundFilename;
        BackgroundMode _backgroundMode;
        int _backgroundR, _backgroundG, _backgroundB;

        char *_headerLeftFilename;
        char *_headerRightFilename;
        char *_headerMiddleFilename;
        char *_headerLeftSelectedFilename;
        char *_headerRightSelectedFilename;
        char *_headerMiddleSelectedFilename;
        char *_borderColor;
        char *_borderActiveColor;

        int _borderWidth;
        int _textLeftMargin;
        int _textRightMargin;
        int _closeButtonXSpan;
        int _closeButtonYSpan;

        int _fontSize;
        int _textYOffset;


        bool _disableSelection;

        bool _showDesktopThumbnail;

        bool _showDesktopByIconify;


        void parseLine(const char *line);
        void parseOpt(const char *key, const char *value);

        bool parseBool(const char *value);

        char* urldecode(const char *url);

    public:
        Settings();
        ~Settings();

        static Settings* instance();

        bool scrollingEnabled() { return _scrollingEnabled; }

        const char* backgroundFilename() { return _backgroundFilename; }
        BackgroundMode backgroundMode() { return _backgroundMode; }
        int backgroundR() { return _backgroundR; }
        int backgroundG() { return _backgroundG; }
        int backgroundB() { return _backgroundB; }

        const char* headerLeftFilename() { return _headerLeftFilename; }
        const char* headerRightFilename() { return _headerRightFilename; }
        const char* headerMiddleFilename() { return _headerMiddleFilename; }
        const char* headerLeftSelectedFilename() { return _headerLeftSelectedFilename; }
        const char* headerRightSelectedFilename() { return _headerRightSelectedFilename; }
        const char* headerMiddleSelectedFilename() { return _headerMiddleSelectedFilename; }
        char* borderColor() { return _borderColor; }
        char* borderActiveColor() { return _borderActiveColor; }

        int borderWidth() { return _borderWidth; }
        int textLeftMargin() { return _textLeftMargin; }
        int textRightMargin() { return _textRightMargin; }
        int closeButtonXSpan() { return _closeButtonXSpan; }
        int closeButtonYSpan() { return _closeButtonYSpan; }

        int fontSize() { return _fontSize; }
        int textYOffset() { return _textYOffset; }

        bool disableSelection() { return _disableSelection; }

        bool showDesktopThumbnail() { return _showDesktopThumbnail; }

        bool showDesktopByIconify() { return _showDesktopByIconify; }
};

#endif
