//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: Mappings.h 94 2010-06-14 08:54:38Z mitrandir $

// Mappings - handling keyboard bindings

#ifndef __TELESCOPE__MAPPINGS_H
#define __TELESCOPE__MAPPINGS_H

#include <X11/Xlib.h>

#include "LinkedList.h"
#include "Mapping.h"

class TeleWindow;

class Mappings
{
    private:
        static Mappings *_instance;

        Display *_dpy;

        LinkedList<Mapping*> _mappings;
        bool _mappingsLoaded;


        void loadMappings();

        void parseLine(const char *line);

    public:
        Mappings(Display *dpy);
        ~Mappings();

        Mappings* instance() { return _instance; }


        void handleEvent(TeleWindow *teleWindow, Mapping::Event event, KeyCode keyCode);
};


#endif
