//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: Main.cpp 95 2010-06-14 08:57:20Z mitrandir $

#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "TeleWindow.h"
#include "XTools.h"
#include "Settings.h"
#include "Resources.h"

int main(int argc, char *argv[])
{
    Settings settings;

    Display *dpy = XOpenDisplay(0);

    if (! dpy)
    {
        fprintf(stderr, "Cannot open display\n");
        return 1;
    }

    XTools::init(dpy);

    if (! XTools::checkCompositeExtension())
    {
        fprintf(stderr, "XServer doesn't support Composite\n");
        return 1;
    }

    if (! XTools::checkDamageExtension())
    {
        fprintf(stderr, "XServer doesn't support Damage\n");
        return 1;
    }

    XTools::enableCompositeRedirect();

    Resources resources(dpy);

    TeleWindow *window = new TeleWindow(dpy);
    //window->show();

    window->eventLoop();

    delete window;

    XCloseDisplay(dpy);
}
