#include "XTools.h"

#include <stdlib.h>
#include <string.h>

#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/extensions/Xcomposite.h>
#include <X11/extensions/Xrender.h>
#include <X11/extensions/Xdamage.h>


Display* XTools::_dpy = 0;

int XTools::_damage_event_base = 0;
int XTools::_damage_error_base = 0;

XTools::ErrorHandler XTools::_prevErrorHandler;

Atom XTools::_NET_CLIENT_LIST;
Atom XTools::_NET_WM_WINDOW_TYPE;
Atom XTools::_NET_WM_WINDOW_TYPE_NORMAL;
Atom XTools::_NET_WM_NAME;
Atom XTools::_NET_WM_STATE;
Atom XTools::_NET_WM_STATE_FULLSCREEN;
Atom XTools::_NET_WM_STATE_HIDDEN;
Atom XTools::_NET_ACTIVE_WINDOW;
Atom XTools::_NET_SHOWING_DESKTOP;
Atom XTools::_NET_CLOSE_WINDOW;
Atom XTools::WM_STATE;
Atom XTools::WM_NAME;


#define INIT_ATOM(dpy, ATOMNAME)        ATOMNAME = XInternAtom((dpy), #ATOMNAME, 0L)

void XTools::init(Display *dpy)
{
    _dpy = dpy;

    INIT_ATOM(dpy, _NET_CLIENT_LIST);
    INIT_ATOM(dpy, _NET_WM_WINDOW_TYPE);
    INIT_ATOM(dpy, _NET_WM_WINDOW_TYPE_NORMAL);
    INIT_ATOM(dpy, _NET_WM_NAME);
    INIT_ATOM(dpy, _NET_WM_STATE);
    INIT_ATOM(dpy, _NET_WM_STATE_FULLSCREEN);
    INIT_ATOM(dpy, _NET_WM_STATE_HIDDEN);
    INIT_ATOM(dpy, _NET_ACTIVE_WINDOW);
    INIT_ATOM(dpy, _NET_SHOWING_DESKTOP);
    INIT_ATOM(dpy, _NET_CLOSE_WINDOW);
    INIT_ATOM(dpy, WM_STATE);
    INIT_ATOM(dpy, WM_NAME);

    checkDamageExtension();

    _prevErrorHandler = XSetErrorHandler(errorHandler);
}

LinkedList<Window> XTools::windowList(Window rootWindow)
{
    LinkedList<Window> list;

    Atom real_type;
    int real_format;
    unsigned long items_read, items_left;
    Window *windows;
    if (XGetWindowProperty(_dpy, rootWindow, _NET_CLIENT_LIST, 0L, 8192L, False,
        XA_WINDOW, &real_type, &real_format, &items_read, &items_left, (unsigned char**)&windows)
        != Success)
    {
        return list;
    }
    else
    {
        for (unsigned int i = 0; i < items_read; i++)
        {
            unsigned long items_read, items_left;
            Atom real_type;
            int real_format;
            Atom *windowType;

            if (XGetWindowProperty(_dpy, windows[i], _NET_WM_WINDOW_TYPE, 0L, 1L, False,
                XA_ATOM, &real_type, &real_format, &items_read, &items_left,
                (unsigned char**)&windowType) != Success)
            {
                continue;
            }
            else
            {
                //bool ok = (items_read > 0 && *windowType == _NET_WM_WINDOW_TYPE_NORMAL);
                bool ok = true;
                if (items_read > 0 && *windowType != _NET_WM_WINDOW_TYPE_NORMAL)
                    ok = false;

                XFree((unsigned char*)windowType);

                if (! ok)
                {
                    continue;
                }
            }

            list.append(windows[i]);
        }

        XFree((unsigned char*)windows);

        return list;
    }
}


char* XTools::windowTitle_alloc(Window window)
{
    XTextProperty wmName;
    XGetTextProperty(_dpy, window, &wmName, _NET_WM_NAME);
    if (wmName.value)
    {
        char *ret = strdup((char*)wmName.value);
        XFree(wmName.value);
        return ret;
    }
    else
    {
        XGetTextProperty(_dpy, window, &wmName, WM_NAME);
        if (wmName.value)
        {
            char *ret = strdup((char*)wmName.value);
            XFree(wmName.value);
            return ret;
        }
        else
        {
            char *ret = (char*)malloc(1);
            *ret = '\0';
            return ret;
        }
    }
}



bool XTools::checkCompositeExtension()
{
    int event_base, error_base;
    if (XCompositeQueryExtension(_dpy, &event_base, &error_base))
    {
        int major = 0, minor = 2;
        XCompositeQueryVersion(_dpy, &major, &minor);

        if (major > 0 || minor >= 2)
            return true;
        else
            return false;
    }
    else
        return false;
}


bool XTools::checkDamageExtension()
{
    if (! XDamageQueryExtension(_dpy, &_damage_event_base, &_damage_error_base))
        return false;

    return true;
}


void XTools::enableCompositeRedirect()
{
    for (int i = 0; i < ScreenCount(_dpy); i++)
        XCompositeRedirectSubwindows(_dpy, RootWindow(_dpy, i), CompositeRedirectAutomatic);
}

void XTools::disableCompositeRedirect()
{
    for (int i = 0; i < ScreenCount(_dpy); i++)
        XCompositeUnredirectSubwindows(_dpy, RootWindow(_dpy, i), CompositeRedirectAutomatic);
}


int XTools::damageEventBase()
{
    return _damage_event_base;
}

int XTools::damageErrorBase()
{
    return _damage_error_base;
}



void XTools::switchToWindow(Window window)
{
    XEvent event;

    event.xclient.type = ClientMessage;
    event.xclient.serial = 0;
    event.xclient.send_event = True;
    event.xclient.message_type = _NET_ACTIVE_WINDOW;
    event.xclient.window = window;
    event.xclient.format = 32;
    event.xclient.data.l[0] = 0;
    event.xclient.data.l[1] = 0;
    event.xclient.data.l[2] = 0;
    event.xclient.data.l[3] = 0;
    event.xclient.data.l[4] = 0;

    XSendEvent(_dpy, DefaultRootWindow(_dpy), False, SubstructureRedirectMask | SubstructureNotifyMask, &event);
}

void XTools::closeWindow(Window window)
{
    XEvent event;

    event.xclient.type = ClientMessage;
    event.xclient.serial = 0;
    event.xclient.send_event = True;
    event.xclient.message_type = _NET_CLOSE_WINDOW;
    event.xclient.window = window;
    event.xclient.format = 32;
    event.xclient.data.l[0] = 0;
    event.xclient.data.l[1] = 0;
    event.xclient.data.l[2] = 0;
    event.xclient.data.l[3] = 0;
    event.xclient.data.l[4] = 0;

    XSendEvent(_dpy, DefaultRootWindow(_dpy), False, SubstructureRedirectMask | SubstructureNotifyMask, &event);
}


int XTools::errorHandler(Display *display, XErrorEvent *event)
{
    printf("X Error! [%d, %d, %d]\n", event->error_code, event->request_code, event->minor_code);

//    _prevErrorHandler(display, event);

    return 0;
}


void XTools::showDesktop()
{
    XEvent event;

    Window root = DefaultRootWindow(_dpy);

    event.xclient.type = ClientMessage;
    event.xclient.serial = 0;
    event.xclient.send_event = True;
    event.xclient.message_type = _NET_SHOWING_DESKTOP;
    event.xclient.window = root;
    event.xclient.format = 32;
    event.xclient.data.l[0] = 1;
    event.xclient.data.l[1] = 1;
    event.xclient.data.l[2] = 0;
    event.xclient.data.l[3] = 0;
    event.xclient.data.l[4] = 0;

    XSendEvent(_dpy, root, False, SubstructureRedirectMask | SubstructureNotifyMask, &event);
}



bool XTools::checkIfWindowMinimized(Window window)
{
    unsigned long *property = NULL;
    unsigned long nitems;
    unsigned long left;
    Atom actual_type;
    int actual_format;

    int status = XGetWindowProperty(_dpy, window, WM_STATE,
        0, 1,
        False, WM_STATE,
        &actual_type, &actual_format,
        &nitems, &left,
        (unsigned char**)&property);

    if (status != Success)
        return false;

    bool minimized = *property == 3;

    XFree(property);

    return minimized;
}



Window XTools::activeWindow()
{
    unsigned long nitems;
    unsigned long left;
    Atom actual_type;
    int actual_format;

    Window *property;

    int status = XGetWindowProperty(_dpy, DefaultRootWindow(_dpy), _NET_ACTIVE_WINDOW,
        0, 1,
        False, XA_WINDOW,
        &actual_type, &actual_format,
        &nitems, &left,
        (unsigned char**)&property
    );

    if (status != Success)
        return 0;

    Window result = *property;

    XFree(property);

    return result;
}
