#ifndef __SETTINGS_H
#define __SETTINGS_H

class Settings
{
    public:
        enum BackgroundMode
        {
            Stretched,
            Centered,
            Scaled,
            Cropped
        };

    private:
        static Settings *_instance;

        bool _scrollingEnabled;
        char *_backgroundFilename;
        BackgroundMode _backgroundMode;

        char *_headerLeftFilename;
        char *_headerRightFilename;
        char *_headerMiddleFilename;
        char *_headerLeftSelectedFilename;
        char *_headerRightSelectedFilename;
        char *_headerMiddleSelectedFilename;
        char *_borderColor;
        char *_borderActiveColor;

        int _borderWidth;
        int _textLeftMargin;
        int _textRightMargin;
        int _closeButtonXSpan;
        int _closeButtonYSpan;

        int _fontSize;
        int _textYOffset;


        void parseLine(const char *line);
        void parseOpt(const char *key, const char *value);

        bool parseBool(const char *value);

        char* urldecode(const char *url);

    public:
        Settings();
        ~Settings();

        static Settings* instance();

        bool scrollingEnabled() { return _scrollingEnabled; }

        const char* backgroundFilename() { return _backgroundFilename; }
        BackgroundMode backgroundMode() { return _backgroundMode; }

        const char* headerLeftFilename() { return _headerLeftFilename; }
        const char* headerRightFilename() { return _headerRightFilename; }
        const char* headerMiddleFilename() { return _headerMiddleFilename; }
        const char* headerLeftSelectedFilename() { return _headerLeftSelectedFilename; }
        const char* headerRightSelectedFilename() { return _headerRightSelectedFilename; }
        const char* headerMiddleSelectedFilename() { return _headerMiddleSelectedFilename; }
        char* borderColor() { return _borderColor; }
        char* borderActiveColor() { return _borderActiveColor; }

        int borderWidth() { return _borderWidth; }
        int textLeftMargin() { return _textLeftMargin; }
        int textRightMargin() { return _textRightMargin; }
        int closeButtonXSpan() { return _closeButtonXSpan; }
        int closeButtonYSpan() { return _closeButtonYSpan; }

        int fontSize() { return _fontSize; }
        int textYOffset() { return _textYOffset; }
};

#endif
