#ifndef __MAPPING_H
#define __MAPPING_H

#include <X11/Xlib.h>


class TeleWindow;

class Mapping
{
    public:
        enum Event
        {
            Press,
            Release
        };

        enum Type
        {
            Shell,
            Internal
        };

    private:
        Event _event;
        KeyCode _keyCode;
        Type _type;
        char *_action;

        Mapping();

        Mapping(Event event, KeyCode keyCode, Type type, const char *action);

    public:
        static Mapping* parseMappingLine(Display *dpy, const char *line, const char **error);
        ~Mapping();

        void handleEvent(TeleWindow *teleWindow, Mapping::Event event, KeyCode keyCode);
        void execute(TeleWindow *teleWindow);
};


#endif
